/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql;

import com.hazelcast.webmonitor.sql.Histories;
import com.hazelcast.webmonitor.sql.QueryHistoryRecord;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class JdbiHistories
implements Histories {
    private static final String USERNAME = "username";
    private static final String CLUSTER = "cluster";
    private final Jdbi jdbi;

    public void save(QueryHistoryRecord historyRecord, int maxLimit) {
        this.jdbi.useTransaction(handle -> {
            Update update;
            int count;
            try (Query query = handle.createQuery("select count(1) from query_history where username = :username and cluster = :cluster");){
                count = (Integer)((Query)((Query)query.bind(USERNAME, historyRecord.getUsername())).bind(CLUSTER, historyRecord.getCluster())).mapTo(Integer.TYPE).first();
            }
            if (count == maxLimit) {
                update = handle.createUpdate("delete from query_history where username = :username       and cluster = :cluster       and execution_time = (            select  min(execution_time) as execution_time            from    query_history            where   username = :username                    and cluster = :cluster            group by username, cluster)");
                try {
                    ((Update)((Update)update.bind(USERNAME, historyRecord.getUsername())).bind(CLUSTER, historyRecord.getCluster())).execute();
                }
                finally {
                    if (update != null) {
                        update.close();
                    }
                }
            }
            update = handle.createUpdate("insert into query_history (cluster, sql_string, username, execution_time, status) values (:cluster, :sqlString, :username, :executionTime, :status)");
            try {
                ((Update)update.bindBean((Object)historyRecord)).execute();
            }
            finally {
                if (update != null) {
                    update.close();
                }
            }
        });
    }

    public Collection<QueryHistoryRecord> findBy(String username, String cluster) {
        return (Collection)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select * from query_history where username = :username and cluster = :cluster order by execution_time asc");){
                List list = (List)((Query)((Query)query.bind(USERNAME, username)).bind(CLUSTER, cluster)).mapToBean(QueryHistoryRecord.class).collect(Collectors.toList());
                return list;
            }
        });
    }

    public void removeByCluster(String cluster) {
        this.jdbi.useHandle(handle -> {
            try (Update update = handle.createUpdate("delete from query_history where cluster = :cluster");){
                ((Update)update.bind(CLUSTER, cluster)).execute();
            }
        });
    }

    public void removeByUser(String username) {
        this.jdbi.useHandle(handle -> {
            try (Update update = handle.createUpdate("delete from query_history where username = :username");){
                ((Update)update.bind(USERNAME, username)).execute();
            }
        });
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JdbiHistories(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

