/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.config.properties.PendoConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.PhoneHomeConfigurationProperties;
import com.hazelcast.webmonitor.repositories.sql.InstanceDataDAO;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.telemetry.InstanceData;
import com.hazelcast.webmonitor.service.telemetry.PendoData;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PendoDataSupplier
implements Supplier<PendoData> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PendoDataSupplier.class);
    private final InstanceDataDAO dao;
    private final LicenseManager licenseManager;
    private final PhoneHomeConfigurationProperties phoneHomeProperties;
    private final PendoConfigurationProperties pendoProperties;

    @Override
    public PendoData get() {
        return PendoData.builder().isPendoEnabled(this.phoneHomeProperties.isEnabled() && !Objects.equals(BuildInfo.getBranding(), "ibm") && this.pendoProperties.isEnabled()).mcInstanceId(this.dao.find().map(InstanceData::getInstanceId).map(Object::toString).orElseGet(() -> {
            if (this.phoneHomeProperties.isEnabled()) {
                log.warn("MC instance ID is not set");
            }
            return "";
        })).isLicensed(this.licenseManager.hasValidLicense()).build();
    }

    @ConstructorProperties(value={"dao", "licenseManager", "phoneHomeProperties", "pendoProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PendoDataSupplier(InstanceDataDAO dao, LicenseManager licenseManager, PhoneHomeConfigurationProperties phoneHomeProperties, PendoConfigurationProperties pendoProperties) {
        this.dao = dao;
        this.licenseManager = licenseManager;
        this.phoneHomeProperties = phoneHomeProperties;
        this.pendoProperties = pendoProperties;
    }
}

