/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.webmonitor.controller.dto.ClusterMetadata;
import com.hazelcast.webmonitor.model.hz.req.state.Version;
import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;

public class ClusterUsageTracker
implements DataCollector {
    private final OperationDispatcher operationDispatcher;
    private final ClusterManager clusterManager;

    public void collectInto(PhoneHomeData data) {
        HashSet clusterNames = new HashSet(this.clusterManager.getConnectedClusterNames());
        List clusters = clusterNames.stream().map(cluster -> this.operationDispatcher.getHZClient(cluster).getCluster()).collect(Collectors.toList());
        data.setMinClusterSize(this.getMinClusterSize(clusters));
        data.setMaxClusterSize(this.getMaxClusterSize(clusters));
        data.setTotalMemberCount(this.getTotalMemberCount(clusters));
        data.setClusters(clusters.size());
        List clusterMetadataList = clusterNames.stream().map(arg_0 -> this.getClusterMetadata(arg_0)).collect(Collectors.toList());
        data.setMinClusterVersion(this.getMinClusterVersion(clusterMetadataList));
        data.setMaxClusterVersion(this.getMaxClusterVersion(clusterMetadataList));
        data.setClusterIds(this.getClusterIds(clusterMetadataList));
    }

    private Set<UUID> getClusterIds(List<ClusterMetadata> clusterMetadataList) {
        return clusterMetadataList.stream().map(ClusterMetadata::getClusterId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Stream<Version> clusterVersions(List<ClusterMetadata> clusterMetadataList) {
        return clusterMetadataList.stream().map(ClusterMetadata::getMemberVersion).map(Version::of);
    }

    private String getMaxClusterVersion(List<ClusterMetadata> clusterMetadataList) {
        return this.clusterVersions(clusterMetadataList).max(Version::compareTo).map(Object::toString).orElse(null);
    }

    private String getMinClusterVersion(List<ClusterMetadata> clusterMetadataList) {
        return this.clusterVersions(clusterMetadataList).min(Version::compareTo).map(Object::toString).orElse(null);
    }

    private ClusterMetadata getClusterMetadata(String cluster) {
        return (ClusterMetadata)this.operationDispatcher.executeOnCluster(cluster, MCClient::getClusterMetadata, e -> String.format("Failed to fetch metadata for cluster %s", cluster));
    }

    private int getMinClusterSize(List<Cluster> clusters) {
        return this.clusterSizeStream(clusters).min().orElse(0);
    }

    private int getMaxClusterSize(List<Cluster> clusters) {
        return this.clusterSizeStream(clusters).max().orElse(0);
    }

    private IntStream clusterSizeStream(List<Cluster> clusters) {
        return clusters.stream().mapToInt(cluster -> cluster.getMembers().size());
    }

    private long getTotalMemberCount(List<Cluster> clusters) {
        return clusters.stream().mapToLong(cluster -> cluster.getMembers().size()).sum();
    }

    @ConstructorProperties(value={"operationDispatcher", "clusterManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterUsageTracker(OperationDispatcher operationDispatcher, ClusterManager clusterManager) {
        this.operationDispatcher = operationDispatcher;
        this.clusterManager = clusterManager;
    }
}

