/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.EventServiceStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.EventServiceMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class EventServiceMXBeanImpl
implements EventServiceMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Services";
    public static final String SERVICE_NAME = "EventService";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String member;
    private volatile EventServiceStatsDTO stats;

    public EventServiceMXBeanImpl(ClusteredStatsService statsService, String cluster, String member) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.member = member;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getEventServiceStats(this.cluster, this.member);
    }

    public String getName() {
        return this.member;
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.cluster, (String)TYPE_NAME, (String)SERVICE_NAME, (String)this.member);
    }

    public int getEventThreadCount() {
        return MXBeanHelper.safeGet((Object)this.stats, EventServiceStatsDTO::getEventThreadCount);
    }

    public int getEventQueueCapacity() {
        return MXBeanHelper.safeGet((Object)this.stats, EventServiceStatsDTO::getEventQueueCapacity);
    }

    public int getEventQueueSize() {
        return MXBeanHelper.safeGet((Object)this.stats, EventServiceStatsDTO::getEventQueueSize);
    }
}

