/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.ClientStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.ClientStatMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.JMXServiceImpl;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.management.ObjectName;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStatMXBeanImpl
implements ClientStatMXBean,
BaseManagementBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientStatMXBeanImpl.class);
    private static final String TYPE_NAME = "ClientStats";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String uuid;
    private volatile ClientStatsDTO stats;

    ClientStatMXBeanImpl(ClusteredStatsService statsService, String cluster, String uuid) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.uuid = uuid;
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectNameOrNull((String)("ManagementCenter[" + this.cluster + "]:type=ClientStats,uuid=" + JMXServiceImpl.quote((String)this.uuid)));
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        ClientEndPointDTO metadata = (ClientEndPointDTO)state.getStatsEnabledClients().get(this.uuid);
        if (metadata == null) {
            return;
        }
        if (state.getClientsPerUuid().get(this.uuid) == null) {
            log.debug("Client with uuid {} is not available anymore", (Object)this.uuid);
            return;
        }
        this.stats = this.statsService.getClientStats(this.cluster, metadata);
    }

    public String getName() {
        return this.uuid;
    }

    public String getAddress() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getAddress);
    }

    public String getType() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getType);
    }

    public String getClientName() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getName);
    }

    public Long getClusterConnectionTimestamp() {
        return (Long)MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getClusterConnectionTimestamp);
    }

    public boolean isEnterprise() {
        return this.stats != null && this.stats.getEnterprise() != null ? this.stats.getEnterprise() : false;
    }

    public String[] getConnectedMembers() {
        return this.stats != null && this.stats.getConnectedMembers() != null ? (String[])this.stats.getConnectedMembers().toArray(String[]::new) : null;
    }

    public String getMemberConnection() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getMemberConnection);
    }

    public String getVersion() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getVersion);
    }

    public long getCommittedVirtualMemorySize() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getCommittedVirtualMemorySize);
    }

    public long getFreePhysicalMemorySize() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getFreePhysicalMemorySize);
    }

    public long getTotalPhysicalMemorySize() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getTotalPhysicalMemorySize);
    }

    public long getFreeSwapSpaceSize() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getFreeSwapSpaceSize);
    }

    public long getTotalSwapSpaceSize() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getTotalSwapSpaceSize);
    }

    public long getFreeHeapMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getFreeHeapMemory);
    }

    public long getMaxHeapMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getMaxHeapMemory);
    }

    public long getTotalHeapMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getTotalHeapMemory);
    }

    public long getUsedHeapMemory() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getUsedHeapMemory);
    }

    public long getOpenFileDescriptorCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getOpenFileDescriptorCount);
    }

    public long getMaxFileDescriptorCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getMaxFileDescriptorCount);
    }

    public long getProcessCpuTime() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getProcessCpuTime);
    }

    public double getSystemLoadAverage() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getSystemLoadAverage);
    }

    public int getAvailableProcessors() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getAvailableProcessors);
    }

    public long getUptime() {
        return MXBeanHelper.safeGet((Object)this.stats, ClientStatsDTO::getUptime);
    }
}

