/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.AttributeComparisonDispatcher;
import com.hazelcast.webmonitor.service.healthcheck.EqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.TpcAttributeEqualityAnalyzer;
import java.util.List;
import java.util.Map;

class TpcAttributeEqualityAnalyzer
extends EqualityAnalyzer {
    TpcAttributeEqualityAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    public String describeSelf() {
        return "Checking if TPC is configured in the same way across members";
    }

    protected List<Problem> identifyProblems(Map<MemberIdentifier, Config> effectiveConfigs) {
        return AttributeComparisonDispatcher.dispatch((Map)this.extractConfigAttribute(effectiveConfigs, Config::getTpcConfig), TpcConfigEquivalence::new);
    }

    String getCheckId() {
        return AnalyzerCheckId.TPC_ATTRIBUTE_EQUALITY_ANALYZER.getCheckId();
    }
}

