/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataPoolAwareAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import java.util.List;

abstract class SourceDataPoolAwareAnalyzer
extends Analyzer {
    protected final CollectingSubscriptionPool pool;

    SourceDataPoolAwareAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        this.pool = new CollectingSubscriptionPool(poolDelegate);
    }

    final AnalysisOutcome doAnalyze(SourceDataFilter filter, IgnoreList ignoreList) {
        if (this.pool.isSubscribedToConfig() && ((MemberConfigMap)this.pool.memberConfigSupplier.get()).isEmpty()) {
            return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), List.of(new ClusterWideProblem("Could not read configuration of any of the cluster members.", "Please try again", Problem.ProblemType.WARNING)));
        }
        return this.doAnalyzeInternal(filter, ignoreList);
    }

    abstract AnalysisOutcome doAnalyzeInternal(SourceDataFilter var1, IgnoreList var2);
}

