/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.model.hz.req.state.LicenseDTO;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.MetricsAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class NativeMemorySizeAnalyzer
extends MetricsAnalyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NativeMemorySizeAnalyzer.class);
    static final String USED_NATIVE_MEMORY_METRIC_NAME = "memory.usedNative";
    static final String ADVICE = "Consider removing some data to avoid a license breach or contacting support to increase the licensed memory limit.";
    private static final double EIGHTY_PERCENT = 0.8;
    private static final double NINETY_PERCENT = 0.9;
    private static final double HUNDRED_PERCENT = 1.0;
    private final ClusterManager clusterManager;
    private final StateManager stateManager;

    NativeMemorySizeAnalyzer(SourceDataSubscriptionPool poolDelegate, ClusterManager clusterManager, StateManager stateManager) {
        super(poolDelegate);
        this.stateManager = stateManager;
        this.clusterManager = clusterManager;
    }

    List<Problem> identifyProblems(String cluster, Stream<Map.Entry<MemberIdentifier, List<MetricDataPoint>>> metricsMap) {
        if (this.stateManager.isStateAvailable(cluster)) {
            return this.clusterManager.getClusterLicense(cluster).filter(licenseDTO -> {
                Set features = licenseDTO.getFeatures();
                return features != null && features.contains(Feature.HD_MEMORY.getText());
            }).map(LicenseDTO::getAllowedNativeMemorySize).filter(size -> size != 0).map(nativeMemorySize -> NativeMemorySizeAnalyzer.getMemberProblems((long)((long)nativeMemorySize.intValue() * 0x40000000L), (Stream)metricsMap)).orElse(Collections.emptyList());
        }
        return List.of(new ClusterWideProblem("Cannot get allowed native memory size information from cluster", "Please verify if Management Center is successfully connected to the cluster members", Problem.ProblemType.WARNING));
    }

    private static List<Problem> getMemberProblems(long nativeMemoryLicensed, Stream<Map.Entry<MemberIdentifier, List<MetricDataPoint>>> metricsMap) {
        return metricsMap.map(entry -> {
            List metricDataPoints = (List)entry.getValue();
            long nativeMemoryUsed = ((MetricDataPoint)metricDataPoints.get(metricDataPoints.size() - 1)).getValue();
            double nativeMemoryUsage = (double)nativeMemoryUsed / (double)nativeMemoryLicensed;
            return Map.entry((MemberIdentifier)entry.getKey(), nativeMemoryUsage);
        }).filter(entry -> (Double)entry.getValue() > 0.8).map(NativeMemorySizeAnalyzer::getProblem).toList();
    }

    private static Problem getProblem(Map.Entry<MemberIdentifier, Double> memberUsage) {
        Double usage = memberUsage.getValue();
        if (usage >= 1.0) {
            return new MemberProblem("The member exceeded the licensed native memory size limit.", "Consider removing some data to avoid a license breach or contacting support to increase the licensed memory limit.", Problem.ProblemType.FAIL, memberUsage.getKey());
        }
        if (usage > 0.9) {
            return new MemberProblem("The member exceeded 90% of the licensed native memory size limit.", "Consider removing some data to avoid a license breach or contacting support to increase the licensed memory limit.", Problem.ProblemType.WARNING, memberUsage.getKey());
        }
        return new MemberProblem("The member exceeded 80% of the licensed native memory size limit.", "Consider removing some data to avoid a license breach or contacting support to increase the licensed memory limit.", Problem.ProblemType.INFO, memberUsage.getKey());
    }

    String getMetricName() {
        return "memory.usedNative";
    }

    public String describeSelf() {
        return "Checking if native memory usage is below the licensed amount";
    }

    String getCheckId() {
        return AnalyzerCheckId.NATIVE_MEMORY_SIZE_ANALYZER.getCheckId();
    }
}

