/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

class MemberMachinesAnalyzer
extends Analyzer {
    private final MemberManager memberManager;

    AnalysisOutcome doAnalyze(SourceDataFilter filter, IgnoreList ignoreList) {
        String cluster = filter.getCluster();
        Set outlierGroups = this.memberManager.streamMultipleMembersListPerIP(cluster).map(entry -> OutlierGroup.of((String)String.format("IP Address is %s", entry.getKey()), ((List)entry.getValue()).stream().map(address -> MemberIdentifier.of((String)cluster, (String)address)).collect(Collectors.toSet()))).collect(Collectors.toSet());
        if (!outlierGroups.isEmpty()) {
            MemberComparisonProblem problem = MemberComparisonProblem.builder().description("Members started on the same machine").advice("Start your members on different machines for better performance").type(Problem.ProblemType.WARNING).outlierGroups(outlierGroups).build();
            return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), List.of(problem));
        }
        return AnalysisOutcome.noProblem((String)this.getCheckId(), (String)this.describeSelf());
    }

    String getCheckId() {
        return AnalyzerCheckId.MEMBER_MACHINES_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if members are running on different machines";
    }

    @ConstructorProperties(value={"memberManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MemberMachinesAnalyzer(MemberManager memberManager) {
        this.memberManager = memberManager;
    }
}

