/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.events.model.ConfigUpdateFinishedEvent;
import com.hazelcast.webmonitor.events.model.ConfigUpdateStartedEvent;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.HealthCheckStatusCountEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@EnableScheduling
public class HealthCheckStatusPublisher {
    private final HealthCheckService healthCheckService;
    private final ClusterManager clusterManager;
    private final ApplicationEventPublisher publisher;
    private final Cache<String, Boolean> dynamicConfigUpdateStatePerCluster = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();

    @Scheduled(fixedRate=10L, initialDelay=10L, timeUnit=TimeUnit.SECONDS)
    public void publishHealthCheckCounts() {
        this.publisher.publishEvent((ApplicationEvent)new HealthCheckStatusCountEvent((Object)"HealthCheckStatusPublisher", this.clusterManager.getConnectedClusterNames().stream().filter(clusterName -> (Boolean)this.dynamicConfigUpdateStatePerCluster.get(clusterName, empty -> false) == false).collect(Collectors.toMap(Function.identity(), arg_0 -> ((HealthCheckService)this.healthCheckService).getHealthcheckStatusCounts(arg_0))), Instant.now().toEpochMilli()));
    }

    @EventListener
    public void configUpdateStarted(ConfigUpdateStartedEvent event) {
        this.dynamicConfigUpdateStatePerCluster.put((Object)event.memberIdent().getClusterName(), (Object)true);
    }

    @EventListener
    public void configUpdateFinished(ConfigUpdateFinishedEvent event) {
        this.dynamicConfigUpdateStatePerCluster.put((Object)event.memberIdent().getClusterName(), (Object)false);
    }

    @ConstructorProperties(value={"healthCheckService", "clusterManager", "publisher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthCheckStatusPublisher(HealthCheckService healthCheckService, ClusterManager clusterManager, ApplicationEventPublisher publisher) {
        this.healthCheckService = healthCheckService;
        this.clusterManager = clusterManager;
        this.publisher = publisher;
    }
}

