/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.controller.dto.CPSubsystemStatusDTO;
import com.hazelcast.webmonitor.service.CPSubsystemManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import java.util.List;

public class CPSubsystemStatusAnalyzer
extends Analyzer {
    private final CPSubsystemManager cpSubsystemManager;
    private final StateManager stateManager;

    CPSubsystemStatusAnalyzer(CPSubsystemManager cpSubsystemManager, StateManager stateManager) {
        this.cpSubsystemManager = cpSubsystemManager;
        this.stateManager = stateManager;
    }

    AnalysisOutcome doAnalyze(SourceDataFilter filter, IgnoreList ignoreList) {
        String cluster = filter.getCluster();
        if (this.stateManager.isStateAvailable(cluster)) {
            if (this.cpSubsystemManager.getStatus(cluster).getStatus() == CPSubsystemStatusDTO.Status.UNSAFE) {
                return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), List.of(new ClusterWideProblem("CP Subsystem is running in unsafe mode", "Please configure some CP members to achieve strong consistency", Problem.ProblemType.WARNING)));
            }
            return AnalysisOutcome.noProblem((String)this.getCheckId(), (String)this.describeSelf());
        }
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), List.of(new ClusterWideProblem("Cannot get CP Subsystem status from cluster", "Please verify if Management Center is successfully connected to the cluster members", Problem.ProblemType.WARNING)));
    }

    String getCheckId() {
        return AnalyzerCheckId.CP_SUBSYSTEM_STATUS_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if CP Subsystem is running in consistency mode";
    }
}

