/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AttributeEquivalence<E> {
    private static final AttributeEquivalence<?> NOOP = new /* Unavailable Anonymous Inner Class!! */;
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeEquivalence.class);
    protected final Map<E, Set<MemberIdentifier>> groupsByValues;
    protected final String ownerObjectDescription;
    private final Function<String, String> problemDescriber;
    private final List<Problem> problems = new ArrayList();

    static <E> AttributeEquivalence<E> noop() {
        return NOOP;
    }

    AttributeEquivalence(Map<E, Set<MemberIdentifier>> groupsByValues, String ownerObjectDescription) {
        this.groupsByValues = groupsByValues;
        this.ownerObjectDescription = ownerObjectDescription;
        this.problemDescriber = ownerObjectDescription == null ? attr -> String.format("The %s attribute is inconsistent across member configurations", attr) : attr -> String.format("The %s attribute is inconsistent across member configurations for %s", attr, ownerObjectDescription);
    }

    abstract void compareEntries();

    final List<Problem> test() {
        try {
            this.compareEntries();
        }
        catch (Exception e) {
            LOGGER.error("exception occurred while running analyzer " + this.getClass().getName(), (Throwable)e);
        }
        return this.problems;
    }

    protected final void addProblem(Problem problem) {
        this.problems.add(Objects.requireNonNull(problem, "problem is null - refusing to adding to problem list"));
    }

    protected final void addProblems(Collection<Problem> problems) {
        problems.stream().filter(Objects::isNull).findAny().ifPresent(n -> {
            throw new NullPointerException("problem is null - refusing to adding to problem list");
        });
        this.problems.addAll(problems);
    }

    protected <EAttr> void deepCompare(Function<E, EAttr> attributeExtractor, String attributeDescription, Function<Map<EAttr, Set<MemberIdentifier>>, AttributeEquivalence<EAttr>> eqCreator) {
        HashMap groupsByAttributeValues = new HashMap(this.groupsByValues.size());
        this.groupsByValues.forEach((eValue, members) -> groupsByAttributeValues.put(attributeExtractor.apply(eValue), members));
        if (this.someMembersMissTheAttribute(groupsByAttributeValues)) {
            Set membersMissingTheElem = (Set)groupsByAttributeValues.remove(null);
            Set membersContainingTheObject = groupsByAttributeValues.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            this.addProblem((Problem)this.createProblemForMissingAttribute(attributeDescription, membersMissingTheElem, membersContainingTheObject));
        }
        if (groupsByAttributeValues.size() > 1) {
            this.addProblems((Collection)eqCreator.apply(groupsByAttributeValues).test());
        }
    }

    private <EAttr> boolean someMembersMissTheAttribute(Map<EAttr, Set<MemberIdentifier>> groupsByAttributeValues) {
        return groupsByAttributeValues.containsKey(null) && groupsByAttributeValues.size() > 1;
    }

    protected <A> void checkSimpleAttributeEquality(Function<E, A> attributeExtractor, String attributeDisplayedName, Problem.ProblemType type) {
        this.compareEntryAttributes(attributeExtractor, i -> attributeDisplayedName + " is " + String.valueOf(i), () -> MemberComparisonProblem.builder().description((String)this.problemDescriber.apply(attributeDisplayedName)).advice(String.format("Set the same %s attribute in all member configurations", attributeDisplayedName)).type(type));
    }

    protected <A> void checkSimpleAttributeEquality(Function<E, A> attributeExtractor, String attributeDisplayedName) {
        this.checkSimpleAttributeEquality(attributeExtractor, attributeDisplayedName, Problem.ProblemType.FAIL);
    }

    private MemberComparisonProblem createProblemForMissingAttribute(String description, Set<MemberIdentifier> membersMissingTheElem, Set<MemberIdentifier> membersContainingTheElem) {
        return MemberComparisonProblem.builder().description(String.format("%s is not configured on all members", description)).advice(String.format("Configure %s on all members", description)).type(Problem.ProblemType.FAIL).addOutlierGroup(OutlierGroup.of((String)String.format("%s is missing", description), membersMissingTheElem)).addOutlierGroup(OutlierGroup.of((String)String.format("%s is configured", description), membersContainingTheElem)).build();
    }

    protected <EAttr> void compareEntryAttributes(Function<E, EAttr> attributeExtractor, Function<EAttr, String> valueDescriptionProvider, Supplier<MemberComparisonProblem.MemberComparisonProblemBuilder> problemBuilderFactory) {
        HashMap<Object, Set> groupsByAttrValues = new HashMap<Object, Set>();
        for (Map.Entry entry : this.groupsByValues.entrySet()) {
            groupsByAttrValues.computeIfAbsent(attributeExtractor.apply(entry.getKey()), __ -> new HashSet()).addAll((Collection)entry.getValue());
        }
        if (groupsByAttrValues.size() > 1) {
            MemberComparisonProblem.MemberComparisonProblemBuilder problemBuilder = problemBuilderFactory.get();
            for (Map.Entry entry : groupsByAttrValues.entrySet()) {
                Object uniqueKeyAttrValue = entry.getKey();
                Set members = (Set)entry.getValue();
                problemBuilder.addOutlierGroup(OutlierGroup.of((String)valueDescriptionProvider.apply(uniqueKeyAttrValue), (Set)members));
            }
            this.problems.add(problemBuilder.build());
        }
    }
}

