/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client;

import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.sql.client.ClientModel;
import com.hazelcast.webmonitor.repositories.sql.ClientDAO;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class ClientUpdater {
    private static final int UPDATE_CLIENTS_SCHEDULE_PERIOD_MINUTES = 1;
    private static final int DELETE_STALE_CLIENTS_SCHEDULE_PERIOD_MINUTES = 60;
    private final ClientDAO clientDAO;
    private final StateManager stateManager;
    private final MetricsConfigurationProperties metricsConfigurationProperties;
    private final Clock clock;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "ClientUpdater"));

    @Autowired
    ClientUpdater(ClientDAO clientDAO, StateManager stateManager, MetricsConfigurationProperties metricsConfigurationProperties) {
        this(clientDAO, stateManager, metricsConfigurationProperties, Clock.systemDefaultZone());
    }

    ClientUpdater(ClientDAO clientDAO, StateManager stateManager, MetricsConfigurationProperties metricsConfigurationProperties, Clock clock) {
        this.clientDAO = clientDAO;
        this.stateManager = stateManager;
        this.metricsConfigurationProperties = metricsConfigurationProperties;
        this.clock = clock;
    }

    @PostConstruct
    void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.updateClients(), 0L, 1L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.deleteStaleClients(), 0L, 60L, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void close() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.scheduledExecutorService);
    }

    void updateClients() {
        Instant now = Instant.now(this.clock);
        for (String cluster : this.stateManager.getClusterNames()) {
            AllState latestState = this.stateManager.getLatestState(cluster);
            if (latestState == null) continue;
            Map clientUuidToClientModelMap = this.clientDAO.findClientsByCluster(cluster).stream().collect(Collectors.toMap(ClientModel::getUuid, Function.identity()));
            List clientModels = latestState.getClientsPerUuid().values().stream().map(clientEndPointDTO -> {
                UUID clientUuid = UUID.fromString(clientEndPointDTO.getUuid());
                ClientModel.ClientModelBuilder clientModelBuilder = Optional.ofNullable((ClientModel)clientUuidToClientModelMap.get(clientUuid)).map(ClientModel::toBuilder).orElseGet(() -> ClientModel.builder().name(clientEndPointDTO.getName()).uuid(clientUuid).cluster(cluster).firstSeenAt(now));
                return clientModelBuilder.lastSeenAt(now).build();
            }).collect(Collectors.toList());
            this.clientDAO.batchUpdate(clientModels);
        }
    }

    void deleteStaleClients() {
        Instant dateTime = Instant.now(this.clock).minus(this.metricsConfigurationProperties.getDiskTtl());
        this.clientDAO.deleteClientsLastSeenBefore(dateTime);
    }
}

