/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.Config;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.controller.dto.MemberDetailsDTO;
import com.hazelcast.webmonitor.controller.dto.MemberStatsWarningDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JetStatus;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.MemberScriptResult;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.NodeState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.model.hz.req.state.Version;
import com.hazelcast.webmonitor.model.sql.MemberModel;
import com.hazelcast.webmonitor.networking.IPAddressUtil;
import com.hazelcast.webmonitor.repositories.sql.MemberDAO;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.SettingsService;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.healthcheck.ProcessorCountThresholdAnalyzer;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.utils.MemberMap;
import com.hazelcast.webmonitor.utils.MemberUtil;
import com.hazelcast.webmonitor.utils.XmlUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class MemberManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemberManager.class);
    public static final long RECOMMENDED_PROCESSORS_THRESHOLD = 8L;
    private static final int SYSTEM_PROPS_CACHE_EXPIRE_DURATION_MINUTES = 10;
    private static final int SYSTEM_PROPS_CACHE_MAX_SIZE = 1000;
    private final LoadingCache<MemberIdentifier, Map<String, String>> systemPropsCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build(key -> {
        try {
            String clusterName = key.getClusterName();
            String memberAddress = key.getMemberAddress();
            Map props = (Map)this.executeOnMember(clusterName, memberAddress, MCClient::getSystemProperties, e -> String.format("Failed to get system properties of member %s from cluster %s: %s", memberAddress, clusterName, e.getMessage()));
            props.replaceAll((k, v) -> v.replace("\r", "\\r").replace("\n", "\\n"));
            return props;
        }
        catch (Exception e2) {
            log.warn("Couldn't load member system properties", (Throwable)e2);
            return null;
        }
    });
    private final StateManager stateManager;
    private final MemberConfigService memberConfigService;
    private final OperationDispatcher dispatcher;
    private final SettingsService settingsService;
    private final MemberDAO memberDAO;
    private final Clock clock;
    private final MCConfigurationProperties mcProperties;
    private final Optional<ProcessorCountThresholdAnalyzer> processorCountThresholdAnalyzer;

    public String getConfig(String cluster, String member) {
        return Optional.ofNullable(this.memberConfigService.getMemberConfig(MemberIdentifier.of((String)cluster, (String)member))).map(MemberConfig::getRawXmlConfig).map(arg_0 -> this.maskConfigProperties(arg_0)).orElse(null);
    }

    public Map<String, MemberConfig> getAllMemberConfigs(String clusterName) {
        return this.getMemberList(clusterName).stream().map(memberAddr -> BiTuple.of((Object)memberAddr, (Object)this.memberConfigService.getMemberConfig(MemberIdentifier.of((String)clusterName, (String)memberAddr)))).filter(pair -> pair.element2 != null).collect(Collectors.toMap(BiTuple::element1, BiTuple::element2));
    }

    public void reloadConfigCache(String cluster) {
        this.memberConfigService.reloadConfigs(cluster);
    }

    public Map<String, String> getSystemProperties(MemberIdentifier memberIdentifier) {
        Map result = (Map)this.systemPropsCache.get((Object)memberIdentifier);
        if (result == null) {
            return Collections.emptyMap();
        }
        List hiddenProperties = this.settingsService.getHiddenProperties();
        return result.entrySet().stream().filter(it -> !hiddenProperties.contains(it.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void runGc(String cluster, String memberAddress) {
        this.executeOnMember(cluster, memberAddress, MCClient::runGc, e -> String.format("Failed to run garbage collection on member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
    }

    public String getThreadDump(String cluster, String memberAddress, boolean dumpDeadLocks) {
        return (String)this.executeOnMember(cluster, memberAddress, (mcClient, member) -> mcClient.getThreadDump(member, dumpDeadLocks), e -> String.format("Failed to get dump of %s threads of member %s from cluster %s: %s", dumpDeadLocks ? "dead-locked" : "all", memberAddress, cluster, e.getMessage()));
    }

    public void shutdown(String cluster, String memberAddress) {
        this.executeOnMember(cluster, memberAddress, (mcClient, member) -> {
            mcClient.shutdownMember(member);
            return CompletableFuture.completedFuture(null);
        }, e -> String.format("Failed to shut down member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
    }

    public void promoteLiteMember(String cluster, String memberAddress) {
        this.executeOnMember(cluster, memberAddress, MCClient::promoteLiteMember, e -> String.format("Failed to promote member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
    }

    public void demoteDataMember(String cluster, String memberAddress) {
        this.executeOnMember(cluster, memberAddress, MCClient::demoteDataMember, e -> String.format("Failed to demote member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
    }

    public Collection<MemberScriptResult> runScript(String cluster, Set<String> memberAddresses, String engine, String script) {
        return this.dispatcher.executeOnMemberAddresses(cluster, memberAddresses, (mcClient, member) -> mcClient.runScript(member, engine, script).thenApply(output -> MemberScriptResult.success((String)MemberUtil.getMemberAddress((Member)member), (String)output)), (member, throwable) -> MemberScriptResult.failure((String)MemberUtil.getMemberAddress((Member)member), (Throwable)throwable));
    }

    public String runConsoleCommand(String cluster, String memberAddress, String namespace, String command) {
        String result = (String)this.executeOnMember(cluster, memberAddress, (mcClient, member) -> mcClient.runConsoleCommand(member, namespace, command), e -> String.format("Failed to execute console command on member %s from cluster %s: %s", memberAddress, cluster, e.getMessage()));
        return result;
    }

    private <T> T executeOnMember(String cluster, String memberAddress, BiFunction<MCClient, Member, CompletableFuture<T>> operation, Function<Exception, String> errorMessageConstructor) {
        return (T)this.dispatcher.executeOnMember(MemberIdentifier.of((String)cluster, (String)memberAddress), operation, errorMessageConstructor);
    }

    public List<MemberDetailsDTO> getMembers(String cluster, long time) {
        return this.getMembers(cluster, time, 0L);
    }

    public Stream<Map.Entry<String, List<String>>> streamMultipleMembersListPerIP(String cluster) {
        Optional<AllState> state = Optional.ofNullable(this.stateManager.getLatestState(cluster));
        return state.map(arg_0 -> this.getMemberStatesByAddress(arg_0)).orElse(Collections.emptyMap()).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> Map.entry((String)entry.getKey(), ((List)entry.getValue()).stream().map(memberState -> memberState.getMemberState().getAddress()).toList()));
    }

    public List<Version> getMemberVersions(String cluster) {
        return Optional.ofNullable(this.stateManager.getLatestState(cluster)).map(AllState::getMemberStates).stream().flatMap(MemberMap::stream).map(MemberState::getNodeState).map(NodeState::getMemberVersion).toList();
    }

    public List<MemberDetailsDTO> getMembers(String cluster, long time, long interval) {
        long time0 = time > 0L ? time : this.clock.currentTimeMillis();
        Optional<AllState> state = Optional.ofNullable(this.stateManager.getLatestState(cluster));
        ArrayList<MemberDetailsDTO> result = new ArrayList<MemberDetailsDTO>();
        List knownMembers = interval == 0L ? this.getHistoricalMemberList(cluster, time0) : this.memberDAO.findMembersInInterval(cluster, Instant.ofEpochMilli(time0 - interval), Instant.ofEpochMilli(time0));
        for (MemberModel memberModel : knownMembers) {
            Optional<TimedMemberState> timedMemberState = state.map(s -> (TimedMemberState)s.getTimedMemberStates().get(memberModel.getAddress()));
            Optional<MemberState> memberState = timedMemberState.map(TimedMemberState::getMemberState);
            long firstSeenAt = memberModel.getFirstSeenAt().toEpochMilli();
            Long lastSeenAt = memberModel.getLastSeenAt() != null ? Long.valueOf(memberModel.getLastSeenAt().toEpochMilli()) : null;
            MemberDetailsDTO memberDetailsDto = MemberDetailsDTO.builder().address(memberModel.getAddress()).uuid((String)memberState.map(MemberState::getUuid).orElse(null)).cpMemberUuid((String)memberState.map(MemberState::getCpMemberUuid).orElse(null)).slowOperations(memberState.map(ms -> ms.getOperationStats().getSlowOperations()).orElse(Collections.emptyList())).ownedPartitions(memberState.map(ms -> ms.getMemberPartitionState().getPartitions().size()).orElse(0).intValue()).time(timedMemberState.map(TimedMemberState::getTime).orElse(0L).longValue()).version((String)memberState.map(ms -> ms.getNodeState().getMemberVersion().toString()).orElse(null)).jetStatus(this.getJetStatus(memberModel)).tpcStatus(this.getTpcStatus(memberModel)).warnings(memberState.map(ms -> this.getWarnings(cluster, ms)).orElse(Collections.emptyList())).scriptingEnabled(timedMemberState.map(TimedMemberState::isScriptingEnabled).orElse(false).booleanValue()).consoleEnabled(timedMemberState.map(TimedMemberState::getConsoleEnabled).orElse(false).booleanValue()).mcDataAccessEnabled(timedMemberState.map(TimedMemberState::getMcDataAccessEnabled).orElse(true).booleanValue()).lite(timedMemberState.map(TimedMemberState::isLite).orElse(false).booleanValue()).firstSeenAt(firstSeenAt).lastSeenAt(lastSeenAt).build();
            result.add(memberDetailsDto);
        }
        return result;
    }

    public JetStatus getJetStatus(MemberConfig config) {
        return Optional.ofNullable(config).map(MemberConfig::toEffectiveConfig).map(Config::getJetConfig).map(jetConfig -> jetConfig.isEnabled() ? JetStatus.ENABLED : JetStatus.DISABLED).orElse(JetStatus.UNKNOWN);
    }

    public JetStatus getJetStatus(MemberModel memberModel) {
        if (memberModel.getLastSeenAt() != null) {
            return JetStatus.UNKNOWN;
        }
        MemberIdentifier memberIdentifier = MemberIdentifier.of((String)memberModel.getCluster(), (String)memberModel.getAddress());
        return this.getJetStatus(this.memberConfigService.getMemberConfig(memberIdentifier));
    }

    public MemberDetailsDTO.TpcStatus getTpcStatus(MemberModel memberModel) {
        if (memberModel.getLastSeenAt() != null) {
            return MemberDetailsDTO.TpcStatus.UNKNOWN;
        }
        MemberIdentifier memberIdentifier = MemberIdentifier.of((String)memberModel.getCluster(), (String)memberModel.getAddress());
        return Optional.ofNullable(this.memberConfigService.getMemberConfig(memberIdentifier)).map(MemberConfig::toEffectiveConfig).map(Config::getTpcConfig).map(tpcConfig -> tpcConfig.isEnabled() ? MemberDetailsDTO.TpcStatus.ENABLED : MemberDetailsDTO.TpcStatus.DISABLED).orElse(MemberDetailsDTO.TpcStatus.UNKNOWN);
    }

    public List<String> getMemberList(String cluster) {
        return this.getMemberList(cluster, this.clock.currentTimeMillis());
    }

    public List<String> getMemberList(String cluster, long time) {
        return this.getHistoricalMemberList(cluster, time).stream().map(MemberModel::getAddress).toList();
    }

    public List<String> getDataMembers(String clusterName) {
        return this.getAllMemberConfigs(clusterName).entrySet().stream().filter(it -> !((MemberConfig)it.getValue()).toEffectiveConfig().isLiteMember()).map(Map.Entry::getKey).toList();
    }

    private List<MemberModel> getHistoricalMemberList(String cluster, long time) {
        return this.memberDAO.findAllByClusterAndTime(cluster, Instant.ofEpochMilli(time));
    }

    @EventListener
    public void onMembersJoined(MembersJoinedEvent event) {
        try {
            String cluster = event.getCluster();
            Set reachableMemberAddresses = event.getReachableMembers().stream().map(MemberUtil::getMemberAddress).collect(Collectors.toSet());
            Instant eventTimestamp = Instant.ofEpochMilli(event.getTimestamp());
            this.memberDAO.insertOrUpdate(cluster, reachableMemberAddresses, eventTimestamp);
        }
        catch (Exception e) {
            log.error("Could not persist members {} data.", (Object)event, (Object)e);
        }
    }

    @EventListener
    public void onMemberLeft(MemberRemovedEvent event) {
        String cluster = event.getCluster();
        Set reacheableMembers = event.getReachableMembers().stream().map(MemberUtil::getMemberAddress).collect(Collectors.toSet());
        try {
            this.memberDAO.updateLastSeenAtIfNotReachable(cluster, reacheableMembers, Instant.ofEpochMilli(event.getTimestamp()));
        }
        catch (Exception e) {
            log.error("Could not persist members {} data.", (Object)event, (Object)e);
        }
        this.systemPropsCache.invalidate((Object)MemberIdentifier.of((String)cluster, (String)MemberUtil.getMemberAddress((Member)event.getRemovedMember())));
    }

    @EventListener
    public void onDisconnectedFromCluster(DisconnectedFromClusterEvent event) {
        String cluster = event.getCluster();
        this.systemPropsCache.asMap().forEach((key, value) -> {
            if (key.getClusterName().equals(cluster)) {
                this.systemPropsCache.invalidate(key);
            }
        });
    }

    private List<MemberStatsWarningDTO> getWarnings(String cluster, MemberState memberState) {
        ArrayList<MemberStatsWarningDTO> warnings = new ArrayList<MemberStatsWarningDTO>();
        if (this.warningsEnabled()) {
            boolean isRunningOnSameMachine = this.getMultipleMembersPerMachine(cluster).contains(memberState.getAddress());
            if (isRunningOnSameMachine) {
                warnings.add(new MemberStatsWarningDTO("sameMachineAsOtherMembers"));
            }
            this.processorCountThresholdAnalyzer.ifPresent(analyzer -> {
                if (analyzer.isProcessorCountBelowThreshold(MemberIdentifier.of((String)cluster, (String)memberState.getAddress()))) {
                    warnings.add(new MemberStatsWarningDTO("availableProcessorsBelowRecommendation", Map.of("processors", Long.toString(8L))));
                }
            });
        }
        return warnings;
    }

    List<String> getMultipleMembersPerMachine(String cluster) {
        return this.streamMultipleMembersListPerIP(cluster).flatMap(entry -> ((List)entry.getValue()).stream()).toList();
    }

    boolean warningsEnabled() {
        return this.mcProperties.getInternal().isMemberWarningsEnabled();
    }

    private Map<String, List<TimedMemberState>> getMemberStatesByAddress(AllState state) {
        return state.getTimedMemberStates().stream().collect(Collectors.groupingBy(memberState -> IPAddressUtil.trimPort((String)memberState.getMemberState().getAddress()), Collectors.toList()));
    }

    private String maskConfigProperties(String rawXmlConfig) {
        List xpathExpressions = this.settingsService.getMaskedConfigProperties();
        return XmlUtil.maskXPathExpressionsInXml((String)rawXmlConfig, (String)"****", (List)xpathExpressions);
    }

    @ConstructorProperties(value={"stateManager", "memberConfigService", "dispatcher", "settingsService", "memberDAO", "clock", "mcProperties", "processorCountThresholdAnalyzer"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MemberManager(StateManager stateManager, MemberConfigService memberConfigService, OperationDispatcher dispatcher, SettingsService settingsService, MemberDAO memberDAO, Clock clock, MCConfigurationProperties mcProperties, Optional<ProcessorCountThresholdAnalyzer> processorCountThresholdAnalyzer) {
        this.stateManager = stateManager;
        this.memberConfigService = memberConfigService;
        this.dispatcher = dispatcher;
        this.settingsService = settingsService;
        this.memberDAO = memberDAO;
        this.clock = clock;
        this.mcProperties = mcProperties;
        this.processorCountThresholdAnalyzer = processorCountThresholdAnalyzer;
    }
}

