/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.client.MCClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class HotRestartManager {
    private final OperationDispatcher dispatcher;

    public void triggerForceStart(String cluster) {
        boolean result = (Boolean)this.dispatcher.executeOnCluster(cluster, MCClient::triggerForceStart, e -> String.format("Failed to trigger Hot Restart force start for cluster %s", cluster));
        if (!result) {
            throw new OperationFailedApiException(String.format("Failed to trigger Hot Restart force start for cluster %s. Check cluster logs for more details.", cluster));
        }
    }

    public void triggerPartialStart(String cluster) {
        boolean result = (Boolean)this.dispatcher.executeOnCluster(cluster, MCClient::triggerPartialStart, e -> String.format("Failed to trigger Hot Restart partial start for cluster %s", cluster));
        if (!result) {
            throw new OperationFailedApiException(String.format("Failed to trigger Hot Restart partial start for cluster %s. Check cluster logs for more details.", cluster));
        }
    }

    public void triggerHotRestartBackup(String cluster) {
        this.dispatcher.executeOnCluster(cluster, MCClient::triggerHotRestartBackup, e -> String.format("Failed to trigger Hot Restart backup for cluster %s", cluster));
    }

    public void interruptHotRestartBackup(String cluster) {
        this.dispatcher.executeOnCluster(cluster, MCClient::interruptHotRestartBackup, e -> String.format("Failed to interrupt Hot Restart backup for cluster %s", cluster));
    }

    @ConstructorProperties(value={"dispatcher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HotRestartManager(OperationDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

