/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.StateManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseServiceProvider {
    private final StateManager stateManager;
    private final LicenseManager licenseManager;

    public Set<String> getClusterNames(Feature feature) {
        this.licenseManager.checkLicensePerFeature(feature);
        return this.stateManager.getClusterNames();
    }

    public AllState getLatestState(String cluster, Feature feature) {
        this.licenseManager.checkLicensePerFeature(feature);
        AllState latestState = this.stateManager.getLatestState(cluster);
        if (latestState == null) {
            throw new NoClusterApiException(cluster);
        }
        return latestState;
    }

    @ConstructorProperties(value={"stateManager", "licenseManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnterpriseServiceProvider(StateManager stateManager, LicenseManager licenseManager) {
        this.stateManager = stateManager;
        this.licenseManager = licenseManager;
    }
}

