/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.HeapMemoryDistributionDTO;
import com.hazelcast.webmonitor.controller.dto.MigrationStateDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.BaseDataPointDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.LongDataPointDTO;
import com.hazelcast.webmonitor.controller.dto.metrics.MetricDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricsQueryService;
import com.hazelcast.webmonitor.metrics.MetricsService;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.PartitionServiceMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.utils.TimeUtil;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.StateManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import lombok.Generated;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ClusterStatsService {
    private static final long LOOKUP_INTERVAL_MS = TimeUtil.ONE_MINUTE_IN_MS;
    private final MetricsQueryService metricsQueryService;
    private final MetricsService metricsService;
    private final StateManager stateManager;
    private final Clock clock;

    public HeapMemoryDistributionDTO getHeapMemoryDistribution(String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            throw new NoClusterApiException(cluster);
        }
        long end = this.clock.currentTimeMillis();
        long start = end - LOOKUP_INTERVAL_MS;
        List result = this.metricsQueryService.queryLatest(cluster, List.of(MetricDTO.builder().metric(Metric.MEMORY_COMMITTED_HEAP).aggregate(MetricDTO.Aggregate.SUM).aggregateBy(MetricDTO.AggregateBy.MEMBERS).build(), MetricDTO.builder().metric(Metric.MEMORY_USED_HEAP).aggregate(MetricDTO.Aggregate.SUM).aggregateBy(MetricDTO.AggregateBy.MEMBERS).build()), start, end);
        SortedSet mapNames = state.getInstanceNames(InstanceType.MAP);
        ArrayList<MetricDTO> queries = new ArrayList<MetricDTO>(mapNames.size());
        for (String map : mapNames) {
            queries.add(MetricDTO.builder().metric(Metric.MAP_HEAP_COST).tag(Tag.NAME, map).aggregate(MetricDTO.Aggregate.SUM).aggregateBy(MetricDTO.AggregateBy.MEMBERS).build());
        }
        long mapsHeapCost = this.metricsQueryService.queryLatest(cluster, queries, start, end).stream().filter(Objects::nonNull).map(LongDataPointDTO.class::cast).mapToLong(LongDataPointDTO::getValue).sum();
        return new HeapMemoryDistributionDTO(ClusterStatsService.getValue((List)result, (int)0), ClusterStatsService.getValue((List)result, (int)1), mapsHeapCost);
    }

    private static long getValue(List<BaseDataPointDTO> result, int index) {
        return Optional.ofNullable(result.get(index)).map(LongDataPointDTO.class::cast).map(BaseDataPointDTO::getValue).orElse(0L);
    }

    public MigrationStateDTO getClusterMigrationState(String cluster) {
        long now = this.clock.currentTimeMillis();
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return MigrationStateDTO.NO_MIGRATION_DATA;
        }
        List unsafeMembers = state.getUnsafeMembers();
        long migrationQueueSize = state.getMembers().stream().map(m -> this.metricsService.queryLatestRaw(((PartitionServiceMetricsQueryFactory.PartitionServiceMetricsQueryFactoryBuilder)((PartitionServiceMetricsQueryFactory.PartitionServiceMetricsQueryFactoryBuilder)((PartitionServiceMetricsQueryFactory.PartitionServiceMetricsQueryFactoryBuilder)((PartitionServiceMetricsQueryFactory.PartitionServiceMetricsQueryFactoryBuilder)PartitionServiceMetricsQueryFactory.builder().cluster(cluster)).member(m)).start(now - LOOKUP_INTERVAL_MS)).end(now)).build().migrationQueueSizeQuery())).flatMap(Optional::stream).max(Comparator.comparing(DataPointAware::getTime)).map(DataPointAware::getValue).orElse(0L);
        return new MigrationStateDTO(unsafeMembers, migrationQueueSize);
    }

    @ConstructorProperties(value={"metricsQueryService", "metricsService", "stateManager", "clock"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterStatsService(MetricsQueryService metricsQueryService, MetricsService metricsService, StateManager stateManager, Clock clock) {
        this.metricsQueryService = metricsQueryService;
        this.metricsService = metricsService;
        this.stateManager = stateManager;
        this.clock = clock;
    }
}

