/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.config.Config;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.webmonitor.controller.dto.cp.AtomicLongStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.AtomicRefStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPGroupMemberMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPGroupMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPMapStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSessionMemberMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSessionMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSubsystemMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CountDownLatchStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.DataStructureStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.FencedLockStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.SemaphoreStatsDTO;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricDataPointProcessor;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class CPStatsRegistry
implements MetricDataPointProcessor {
    private static final int CP_REGISTRY_MAX_SIZE = 100000;
    private static final int CP_REGISTRY_TTL_MIN = 1;
    private final StateManager stateManager;
    private final MemberConfigService memberConfigService;
    private final Clock clock;
    private final int maxSize;
    private final int ttlMinutes;
    private final ConcurrentMap<String, Cache<String, CPGroupMetricsDTO>> knownGroups = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, CPSessionMetricsDTO>> knownSessions = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, AtomicLongStatsDTO>> knownAtomicLongs = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, SemaphoreStatsDTO>> knownSemaphores = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, AtomicRefStatsDTO>> knownAtomicRefs = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, FencedLockStatsDTO>> knownFencedLocks = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, CountDownLatchStatsDTO>> knownCountdownLatches = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, CPMapStatsDTO>> knownCPMaps = new ConcurrentHashMap();
    private final ConcurrentMap<String, Cache<String, CPSubsystemMetricsDTO>> cpSubsystemStats = new ConcurrentHashMap();

    @Autowired
    public CPStatsRegistry(StateManager stateManager, MemberConfigService memberConfigService, Clock clock) {
        this.stateManager = stateManager;
        this.memberConfigService = memberConfigService;
        this.clock = clock;
        this.maxSize = 100000;
        this.ttlMinutes = 1;
    }

    @EventListener
    public void cleanUpDisconnectedCluster(DisconnectedFromClusterEvent event) {
        String cluster = event.getCluster();
        this.knownGroups.remove(cluster);
        this.knownSessions.remove(cluster);
        this.knownAtomicLongs.remove(cluster);
        this.knownAtomicRefs.remove(cluster);
        this.knownSemaphores.remove(cluster);
        this.knownCountdownLatches.remove(cluster);
        this.knownFencedLocks.remove(cluster);
        this.knownCPMaps.remove(cluster);
    }

    public boolean shouldProcessDataPoint(MetricDataPoint dataPoint) {
        String dataPointName = dataPoint.getName();
        return dataPointName.startsWith("cp") || dataPointName.startsWith("raft");
    }

    public void processDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        String dataPointName = dataPoint.getName();
        if (dataPointName.startsWith("raft.group")) {
            this.processGroupDataPoint(dataPoint, memberIdent);
        } else if (dataPointName.startsWith("raft")) {
            this.processSubsystemDataPoint(dataPoint, memberIdent);
        } else if (dataPointName.startsWith("cp.session")) {
            this.processSessionDataPoint(dataPoint, memberIdent);
        } else if (dataPointName.startsWith("cp.")) {
            this.processDataStructureDataPoint(dataPoint, memberIdent);
        }
    }

    private void processSubsystemDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        String cluster = memberIdent.getClusterName();
        Cache cache = this.cpSubsystemStats.computeIfAbsent(cluster, key -> this.createEntityCache());
        String member = memberIdent.getMemberAddress();
        cache.asMap().compute(member, (k, v) -> {
            CPSubsystemMetricsDTO subsystemRecord = v;
            if (subsystemRecord == null) {
                subsystemRecord = CPSubsystemMetricsDTO.builder().member(member).build();
            }
            switch (dataPoint.getName()) {
                case "raft.nodes": {
                    subsystemRecord.setNodes(dataPoint.getValue());
                    break;
                }
                case "raft.metadata.groups": {
                    subsystemRecord.setGroups(dataPoint.getValue());
                    break;
                }
                case "raft.destroyedGroupIds": {
                    subsystemRecord.setDestroyedGroups(dataPoint.getValue());
                    break;
                }
                case "raft.metadata.activeMembers": {
                    subsystemRecord.setActiveMembers(dataPoint.getValue());
                    break;
                }
                case "raft.missingMembers": {
                    subsystemRecord.setMissingMembers(dataPoint.getValue());
                    break;
                }
            }
            return subsystemRecord;
        });
    }

    private void processGroupDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        Map tags = dataPoint.getTags();
        String id = (String)tags.get(Tag.GROUP_ID.getName());
        if (id == null) {
            return;
        }
        String cluster = memberIdent.getClusterName();
        String member = memberIdent.getMemberAddress();
        String memberRole = (String)dataPoint.getTags().get(Tag.ROLE.getName());
        String groupName = (String)dataPoint.getTags().get(Tag.NAME.getName());
        Cache cache = this.knownGroups.computeIfAbsent(cluster, key -> this.createEntityCache());
        String cacheKey = groupName + "_" + id;
        cache.asMap().compute(cacheKey, (k, v) -> {
            CPGroupMemberMetricsDTO memberDTO;
            CPGroupMetricsDTO groupRecord = v;
            if (groupRecord == null) {
                groupRecord = CPGroupMetricsDTO.builder().groupId(id).groupName(groupName).members(new TreeMap()).build();
            }
            if (!Objects.equals((memberDTO = groupRecord.getMembers().computeIfAbsent(member, m -> {
                int priority = this.computeCpMemberPriority(memberIdent);
                return CPGroupMemberMetricsDTO.builder().member(member).role(memberRole).cpMemberPriority(priority).build();
            })).getRole(), memberRole)) {
                memberDTO.setRole(memberRole);
            }
            memberDTO.setLastSeenAt(dataPoint.getTime());
            switch (dataPoint.getName()) {
                case "raft.group.term": {
                    memberDTO.setTerm(dataPoint.getValue());
                    break;
                }
                case "raft.group.commitIndex": {
                    memberDTO.setCommitIndex(dataPoint.getValue());
                    break;
                }
                case "raft.group.lastApplied": {
                    memberDTO.setLastApplied(dataPoint.getValue());
                    break;
                }
                case "raft.group.lastLogTerm": {
                    memberDTO.setLastLogTerm(dataPoint.getValue());
                    break;
                }
                case "raft.group.snapshotIndex": {
                    memberDTO.setSnapshotIndex(dataPoint.getValue());
                    break;
                }
                case "raft.group.lastLogIndex": {
                    memberDTO.setLastLogIndex(dataPoint.getValue());
                    break;
                }
                case "raft.group.availableLogCapacity": {
                    memberDTO.setAvailableLogCapacity(dataPoint.getValue());
                    break;
                }
            }
            return groupRecord;
        });
    }

    private void processSessionDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        Map tags = dataPoint.getTags();
        String id = (String)tags.get(Tag.ID.getName());
        String group = (String)tags.get(Tag.GROUP.getName());
        if (id == null) {
            return;
        }
        String cluster = memberIdent.getClusterName();
        String member = memberIdent.getMemberAddress();
        Cache cache = this.knownSessions.computeIfAbsent(cluster, key -> this.createEntityCache());
        cache.asMap().compute(id, (k, v) -> {
            CPSessionMetricsDTO sessionRecord = v;
            if (sessionRecord == null) {
                sessionRecord = CPSessionMetricsDTO.builder().id(id).group(group).members(new TreeMap()).build();
            }
            CPSessionMemberMetricsDTO cpSessionMemberMetricsDTO = sessionRecord.getMembers().computeIfAbsent(member, m -> CPSessionMemberMetricsDTO.builder().member(member).build());
            sessionRecord.setSessionId((String)tags.get(Tag.SESSION_ID.getName()));
            String endpoint = (String)tags.get(Tag.ENDPOINT.getName());
            if (endpoint != null) {
                sessionRecord.setEndpoint(endpoint);
            }
            if (dataPoint.getName().equals("cp.session.endpointName")) {
                sessionRecord.setEndpointName((String)tags.get(Tag.ENDPOINT_NAME.getName()));
            } else if (sessionRecord.getEndpointName() == null && endpoint != null) {
                sessionRecord.setEndpointName(this.getMatchingEndpointName(cluster, endpoint));
            }
            if (dataPoint.getName().equals("cp.session.endpointType")) {
                sessionRecord.setEndpointType((String)tags.get(Tag.ENDPOINT_TYPE.getName()));
            }
            if (dataPoint.getName().equals("cp.session.creationTime")) {
                cpSessionMemberMetricsDTO.setCreationTime(dataPoint.getValue());
            }
            if (dataPoint.getName().equals("cp.session.expirationTime")) {
                cpSessionMemberMetricsDTO.setExpirationTime(dataPoint.getValue());
            }
            if (dataPoint.getName().equals("cp.session.version")) {
                cpSessionMemberMetricsDTO.setVersion(dataPoint.getValue());
            }
            return sessionRecord;
        });
    }

    private void processDataStructureDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        String metricName = dataPoint.getName();
        int secondDotIndex = metricName.indexOf(".", metricName.indexOf(".") + 1);
        String trimmedMetric = metricName.substring(0, secondDotIndex);
        Map tags = dataPoint.getTags();
        String id = (String)tags.get(Tag.ID.getName());
        if (id == null) {
            return;
        }
        String cluster = memberIdent.getClusterName();
        switch (trimmedMetric) {
            case "cp.atomiclong": {
                this.updateInCache(cluster, this.knownAtomicLongs, dataPoint, AtomicLongStatsDTO::new);
                return;
            }
            case "cp.semaphore": {
                this.updateInCache(cluster, this.knownSemaphores, dataPoint, SemaphoreStatsDTO::new);
                return;
            }
            case "cp.atomicref": {
                this.updateInCache(cluster, this.knownAtomicRefs, dataPoint, AtomicRefStatsDTO::new);
                return;
            }
            case "cp.lock": {
                this.updateInCache(cluster, this.knownFencedLocks, dataPoint, FencedLockStatsDTO::new);
                return;
            }
            case "cp.countdownlatch": {
                this.updateInCache(cluster, this.knownCountdownLatches, dataPoint, CountDownLatchStatsDTO::new);
                return;
            }
            case "cp.map": {
                this.updateInCache(cluster, this.knownCPMaps, dataPoint, CPMapStatsDTO::new);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown CP type");
    }

    private <T extends DataStructureStatsDTO> void updateInCache(String cluster, ConcurrentMap<String, Cache<String, T>> map, MetricDataPoint dataPoint, Supplier<T> supplier) {
        Map tags = dataPoint.getTags();
        String cacheKey = (String)tags.get(Tag.GROUP.getName()) + "_" + (String)tags.get(Tag.ID.getName());
        Cache cache = map.computeIfAbsent(cluster, key -> this.createEntityCache());
        cache.asMap().compute(cacheKey, (k, v) -> {
            DataStructureStatsDTO cpStructureRecord = v;
            if (cpStructureRecord == null) {
                cpStructureRecord = (DataStructureStatsDTO)supplier.get();
                cpStructureRecord.setCluster(cluster);
                cpStructureRecord.setName((String)tags.get(Tag.NAME.getName()));
                cpStructureRecord.setGroup((String)tags.get(Tag.GROUP.getName()));
            }
            cpStructureRecord.updateFields(dataPoint);
            return cpStructureRecord;
        });
    }

    private String getMatchingEndpointName(String cluster, String endpoint) {
        Map clients = this.stateManager.getClients(cluster);
        return clients.values().stream().filter(client -> {
            String endpointFromClientInfo = client.getAddress().replace(client.getCanonicalHostName(), String.format("[%s]", client.getIpAddress()));
            return endpointFromClientInfo.equals(endpoint);
        }).findFirst().map(ClientEndPointDTO::getName).orElse(null);
    }

    public Map<String, CPSessionMetricsDTO> getKnownSessions(String cluster) {
        return this.getKnown(this.knownSessions, cluster);
    }

    public Map<String, AtomicLongStatsDTO> getKnownAtomicLongs(String cluster) {
        return this.getKnown(this.knownAtomicLongs, cluster);
    }

    public Map<String, SemaphoreStatsDTO> getKnownSemaphores(String cluster) {
        return this.getKnown(this.knownSemaphores, cluster);
    }

    public Map<String, AtomicRefStatsDTO> getKnownAtomicRefs(String cluster) {
        return this.getKnown(this.knownAtomicRefs, cluster);
    }

    public Map<String, FencedLockStatsDTO> getKnownFencedLocks(String cluster) {
        return this.getKnown(this.knownFencedLocks, cluster);
    }

    public Map<String, CountDownLatchStatsDTO> getKnownCountdownLatches(String cluster) {
        return this.getKnown(this.knownCountdownLatches, cluster);
    }

    public Map<String, CPMapStatsDTO> getKnownCPMaps(String cluster) {
        return this.getKnown(this.knownCPMaps, cluster);
    }

    public Map<String, CPGroupMetricsDTO> getKnownGroups(String cluster) {
        return this.getKnown(this.knownGroups, cluster);
    }

    public Map<String, CPSubsystemMetricsDTO> getCpSubsystemStats(String cluster) {
        return this.getKnown(this.cpSubsystemStats, cluster);
    }

    public boolean isAnyCPDataStructurePresent(String cluster) {
        return Stream.of(this.getKnownAtomicLongs(cluster), this.getKnownSemaphores(cluster), this.getKnownAtomicRefs(cluster), this.getKnownCountdownLatches(cluster), this.getKnownFencedLocks(cluster), this.getKnownCPMaps(cluster)).anyMatch(Predicate.not(Map::isEmpty));
    }

    private <T> Cache<String, T> createEntityCache() {
        return Caffeine.newBuilder().expireAfterWrite((long)this.ttlMinutes, TimeUnit.MINUTES).maximumSize((long)this.maxSize).ticker(() -> ((Clock)this.clock).nanoTime()).build();
    }

    private <T> Map<String, T> getKnown(ConcurrentMap<String, Cache<String, T>> knownDS, String cluster) {
        Cache cache = (Cache)knownDS.get(cluster);
        return cache == null ? Collections.emptyMap() : Map.copyOf(cache.asMap());
    }

    private int computeCpMemberPriority(MemberIdentifier memberIdentifier) {
        return Optional.ofNullable(this.memberConfigService.getMemberConfig(memberIdentifier)).map(MemberConfig::toEffectiveConfig).map(Config::getCPSubsystemConfig).map(CPSubsystemConfig::getCPMemberPriority).orElse(0);
    }

    public void removeCPSessionFromCache(String cluster, String groupName, long sessionId) {
        this.knownSessions.computeIfPresent(cluster, (key, cache) -> {
            String cacheKey = sessionId + "@" + groupName;
            cache.invalidate((Object)cacheKey);
            return cache;
        });
    }

    @ConstructorProperties(value={"stateManager", "memberConfigService", "clock", "maxSize", "ttlMinutes"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CPStatsRegistry(StateManager stateManager, MemberConfigService memberConfigService, Clock clock, int maxSize, int ttlMinutes) {
        this.stateManager = stateManager;
        this.memberConfigService = memberConfigService;
        this.clock = clock;
        this.maxSize = maxSize;
        this.ttlMinutes = ttlMinutes;
    }
}

