/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.saml;

import com.coveo.saml.SamlClient;
import com.coveo.saml.SamlException;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.SecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.PersistentSamlConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.SamlConfig;
import com.hazelcast.webmonitor.security.spi.impl.saml.SamlSecurityProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class SamlSecurityProvider
implements SecurityProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SamlSecurityProvider.class);
    public static final String SAML_SECURITY_PROVIDER_NAME = "SAML";
    private static final int TEST_CONFIG_IDP_CONNECTION_TIMEOUT_MILLIS = 5000;
    private final AuthenticationProvider authenticationProvider = new NoOpAuthenticationProvider();
    private final PersistentSamlConfig persistentSamlConfig;

    public String getName() {
        return "SAML";
    }

    public void saveConfig(Map<String, String> parameters) {
        this.persistentSamlConfig.write((SecurityProviderConfig)SamlConfig.fromMap(parameters));
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public Optional<String> testConfig(String username, String password, Map<String, String> parameters) {
        UrlEncodedFormEntity entity;
        SamlConfig config = SamlConfig.fromMap(parameters);
        SamlClient samlClient = SamlSecurityProvider.newSamlClient((SamlConfig)config);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).build();
        try {
            entity = new UrlEncodedFormEntity(List.of(new BasicNameValuePair("SAMLRequest", samlClient.getSamlRequest())), StandardCharsets.UTF_8);
        }
        catch (SamlException e) {
            throw new SecurityConfigApiException("Failed to get SAML request: " + e.getMessage(), (Throwable)e);
        }
        String idpUrl = samlClient.getIdentityProviderUrl();
        HttpUriRequest request = RequestBuilder.post((String)idpUrl).setConfig(requestConfig).setEntity((HttpEntity)entity).build();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();
             CloseableHttpResponse response = httpClient.execute(request);){
            HttpStatus status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
            if (!status.is2xxSuccessful() && !status.is3xxRedirection()) {
                throw new SecurityConfigApiException("POST request to SAML Identity Provider located at " + idpUrl + " returned " + String.valueOf(status));
            }
        }
        catch (IOException e) {
            throw new SecurityConfigApiException("Failed to make a POST request to SAML Identity Provider located at " + idpUrl, (Throwable)e);
        }
        return Optional.empty();
    }

    public SamlClient newSamlClient() {
        return SamlSecurityProvider.newSamlClient((SamlConfig)this.persistentSamlConfig.get());
    }

    public SamlConfig readConfig() {
        return this.persistentSamlConfig.get();
    }

    private static SamlClient newSamlClient(SamlConfig config) {
        try {
            SamlSecurityProvider.initializeOpenSAML();
            return SamlClient.fromMetadata((String)config.getRelyingPartyId(), (String)config.getPostBackUrl(), (Reader)new StringReader(config.getIdpMetadata()));
        }
        catch (SamlException | ClassNotFoundException | IllegalAccessException | InstantiationException | InitializationException e) {
            throw new SecurityConfigApiException("Failed to create SAML client: " + e.getMessage(), e);
        }
    }

    private static void initializeOpenSAML() throws ClassNotFoundException, InitializationException, InstantiationException, IllegalAccessException {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Initializer.class));
        Set components = provider.findCandidateComponents("org/opensaml");
        for (BeanDefinition component : components) {
            Class<?> cls = Class.forName(component.getBeanClassName());
            ((Initializer)cls.newInstance()).init();
        }
    }

    @ConstructorProperties(value={"persistentSamlConfig"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SamlSecurityProvider(PersistentSamlConfig persistentSamlConfig) {
        this.persistentSamlConfig = persistentSamlConfig;
    }
}

