/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.ldap;

import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.PersistentSecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.LdapConfig;
import com.hazelcast.webmonitor.utils.KeystoreUtil;
import java.io.File;
import java.util.Properties;
import org.jdbi.v3.core.Jdbi;

public class BuiltInKeystorePersistentLdapConfig
extends PersistentSecurityProviderConfig<LdapConfig> {
    private final Jdbi jdbi;
    private final String builtInKeystorePath;
    private final String builtInKeystorePassword;

    public BuiltInKeystorePersistentLdapConfig(Jdbi jdbi, GroupedSettingsDAO groupedSettingsDAO, String builtInKeystorePath, String builtInKeystorePassword) {
        super(groupedSettingsDAO);
        this.jdbi = jdbi;
        this.builtInKeystorePath = builtInKeystorePath;
        this.builtInKeystorePassword = builtInKeystorePassword;
        if (!new File(builtInKeystorePath).exists()) {
            KeystoreUtil.create((String)builtInKeystorePath, (String)builtInKeystorePassword);
        }
    }

    public LdapConfig get() {
        Properties props = super.getProperties();
        props.setProperty("password", KeystoreUtil.load((String)this.builtInKeystorePath, (String)this.builtInKeystorePassword));
        return LdapConfig.fromProperties((Properties)props);
    }

    public void write(LdapConfig ldapConfig) {
        this.jdbi.useTransaction(handle -> {
            Properties props = ldapConfig.toPropertiesWithoutPassword();
            this.groupedSettingsDAO.saveTx(handle, "securityProvider", props);
            KeystoreUtil.store((String)this.builtInKeystorePath, (String)this.builtInKeystorePassword, (String)ldapConfig.getPassword());
        });
    }
}

