/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl;

import com.hazelcast.webmonitor.security.UserHasNoRolesException;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;

/*
 * Exception performing whole class analysis ignored.
 */
public final class GroupsToAuthoritiesMapper {
    private GroupsToAuthoritiesMapper() {
    }

    public static Set<GrantedAuthority> mapGroupsToAuthorities(Collection<String> groups, GroupsToRolesMappingConfig config) {
        if (GroupsToAuthoritiesMapper.containsAnyGroup(groups, (String[])config.getAdminGroups())) {
            return Set.of(SecurityProvider.ADMIN_AUTHORITY);
        }
        if (GroupsToAuthoritiesMapper.containsAnyGroup(groups, (String[])config.getUserGroups())) {
            return Set.of(SecurityProvider.USER_AUTHORITY);
        }
        if (GroupsToAuthoritiesMapper.containsAnyGroup(groups, (String[])config.getReadonlyUserGroups())) {
            return Set.of(SecurityProvider.READONLY_USER_AUTHORITY);
        }
        if (GroupsToAuthoritiesMapper.containsAnyGroup(groups, (String[])config.getMetricsOnlyGroups())) {
            return Set.of(SecurityProvider.METRICS_ONLY_AUTHORITY);
        }
        return Collections.emptySet();
    }

    public static Set<GrantedAuthority> mapGroupsToAuthoritiesOrThrow(Collection<String> groups, GroupsToRolesMappingConfig config) {
        Set grantedAuthorities = GroupsToAuthoritiesMapper.mapGroupsToAuthorities(groups, (GroupsToRolesMappingConfig)config);
        if (grantedAuthorities.isEmpty()) {
            throw new UserHasNoRolesException();
        }
        return grantedAuthorities;
    }

    private static boolean containsAnyGroup(Collection<String> idpGroups, String[] configuredGroups) {
        return Arrays.stream(configuredGroups).anyMatch(group -> idpGroups.stream().anyMatch(group::equalsIgnoreCase));
    }
}

