/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.UserCredentialsModel;
import com.hazelcast.webmonitor.utils.CryptoUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class UserCredentialsDAO {
    private final Jdbi jdbi;

    public void insert(UserCredentialsModel user) {
        this.jdbi.useHandle(handle -> this.insertTx(handle, user));
    }

    public void insertTx(Handle handle, UserCredentialsModel user) {
        String hashedPass = CryptoUtils.generatePasswordHash((String)user.getUsername(), (String)user.getPassword());
        try (Update update = handle.createUpdate("insert into user_credentials (username, password, role) values (:username, :password, :role)");){
            ((Update)((Update)((Update)update.bind("username", user.getUsername())).bind("password", hashedPass)).bind("role", user.getRole())).execute();
        }
    }

    public void update(UserCredentialsModel user) {
        this.jdbi.withHandle(handle -> {
            try (Update update = handle.createUpdate("update user_credentials set password = :password, role = :role where username = :username");){
                Integer n = ((Update)((Update)((Update)update.bind("username", user.getUsername())).bind("password", user.getPassword())).bind("role", user.getRole())).execute();
                return n;
            }
        });
    }

    public List<UserCredentialsModel> getUsers() {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select username, role from user_credentials order by username");){
                List list = query.mapToBean(UserCredentialsModel.class).list();
                return list;
            }
        });
    }

    public List<String> getUsernamesTx(Handle handle) {
        try (Query query = handle.createQuery("select username from user_credentials order by username");){
            List list = query.mapTo(String.class).list();
            return list;
        }
    }

    public void delete(String username) {
        this.jdbi.withHandle(handle -> this.deleteTx(handle, username));
    }

    public int deleteTx(Handle handle, String username) {
        try (Update update = handle.createUpdate("delete from user_credentials where username = :username");){
            int n = ((Update)update.bind("username", username)).execute();
            return n;
        }
    }

    public Optional<UserCredentialsModel> login(String username, String providedPassword) {
        Optional user = this.findByUsername(username);
        String providedPasswordHash = CryptoUtils.generatePasswordHash((String)username, (String)providedPassword);
        return user.filter(userWithPassword -> userWithPassword.getPassword().equals(providedPasswordHash));
    }

    public Optional<UserCredentialsModel> findByUsername(String username) {
        return (Optional)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("select username, password, role from user_credentials where username = :username");){
                Optional optional = ((Query)query.bind("username", username)).mapToBean(UserCredentialsModel.class).findFirst();
                return optional;
            }
        });
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UserCredentialsDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

