/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.TablePreset;
import com.hazelcast.webmonitor.model.sql.TablePresetColumn;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class TablePresetDAO {
    private static final String LEGACY_PRESET_USERNAME = "default_table_presets";
    private final Jdbi jdbi;

    public List<TablePreset> findPresetsByTableId(String tableId, String username) {
        List presets = (List)this.jdbi.withHandle(handle -> this.findByTableIdTx(handle, tableId, username));
        if (presets.isEmpty()) {
            List legacyPresets = (List)this.jdbi.withHandle(handle -> this.findByTableIdTx(handle, tableId, LEGACY_PRESET_USERNAME));
            this.insertOrUpdate(tableId, legacyPresets, username);
            presets = (List)this.jdbi.withHandle(handle -> this.findByTableIdTx(handle, tableId, username));
        }
        return presets;
    }

    private List<TablePreset> findByTableIdTx(Handle handle, String tableId, String username) {
        try (Query query = handle.createQuery("SELECT\np.id               p_id,\np.table_id         p_table_id,\np.name             p_name,\np.readonly         p_readonly,\np.current          p_current,\np.page_size        p_page_size,\nc.position         position,\nc.hidden           hidden,\nc.sort             sort,\nc.column_name      column_name,\nc.width            width\nFROM table_presets p LEFT JOIN table_preset_columns c ON c.preset_id = p.id AND c.username = p.username\nWHERE p.table_id = :table_id AND p.username = :username\n");){
            List<TablePreset> list = ((Query)((Query)((Query)query.bind("table_id", tableId)).bind("username", username)).registerRowMapper(BeanMapper.factory(TablePreset.class, (String)"p"))).reduceRows((map, rowView) -> {
                TablePreset preset = map.computeIfAbsent((String)rowView.getColumn("id", String.class), id -> (TablePreset)rowView.getRow(TablePreset.class));
                String columnName = (String)rowView.getColumn("column_name", String.class);
                if (columnName != null) {
                    Integer width = (Integer)rowView.getColumn("width", Integer.class);
                    Boolean sort = (Boolean)rowView.getColumn("sort", Boolean.class);
                    Boolean hidden = (Boolean)rowView.getColumn("hidden", Boolean.class);
                    Integer position = (Integer)rowView.getColumn("position", Integer.class);
                    preset.getColumns().add(new TablePresetColumn(columnName, hidden, sort, position, width));
                }
            }).toList();
            return list;
        }
    }

    public void insertOrUpdate(String tableId, List<TablePreset> presets, String username) {
        this.jdbi.inTransaction(handle -> {
            this.deleteAllPresetsOfTableTx(handle, tableId, username);
            presets.forEach(preset -> this.insertTx(handle, tableId, preset, username));
            return null;
        });
    }

    private void insertTx(Handle handle, String tableId, TablePreset preset, String username) {
        handle.useTransaction(h -> {
            try (Update update = h.createUpdate("INSERT INTO table_presets (table_id, username, id, name, readonly, current, page_size)\nVALUES (:table_id, :username, :id, :name, :readonly, :current, :pageSize)\n");){
                ((Update)((Update)((Update)update.bindBean((Object)preset)).bind("table_id", tableId)).bind("username", username)).execute();
            }
            try (PreparedBatch batch = handle.prepareBatch("INSERT INTO table_preset_columns (preset_id, username, column_name, position, sort, hidden, width)\nVALUES (:preset_id, :username, :columnName, :position, :sort, :hidden, :width)\n");){
                preset.getColumns().forEach(column -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bindBean(column)).bind("preset_id", preset.getId())).bind("username", username)).add());
                batch.execute();
            }
        });
    }

    private void deleteAllPresetsOfTableTx(Handle handle, String tableId, String username) {
        try (Update update = handle.createUpdate("DELETE FROM table_presets WHERE table_id = :table_id AND username = :username");){
            ((Update)((Update)update.bind("table_id", tableId)).bind("username", username)).execute();
        }
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TablePresetDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

