/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.prometheus.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricPrinter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="hazelcast.mc.prometheus-exporter")
class PrometheusExporterConfigurationProperties {
    private boolean enabled;
    private Integer port;
    @Value(value="${hazelcast.mc.prometheusExporter.timestamp.enabled:true}")
    private boolean timeStampEnabled = true;
    @Value(value="${hazelcast.mc.prometheusExporter.filter.metrics.included:}")
    private Set<@NotBlank String> allowList = new HashSet();
    @Value(value="${hazelcast.mc.prometheusExporter.filter.metrics.excluded:}")
    private Set<@NotBlank String> denyList = new HashSet();
    @NotEmpty
    private Set<PrometheusMetricPrinter.PrinterVersion> printers = EnumSet.allOf(PrometheusMetricPrinter.PrinterVersion.class);
    private List<MetricMapping> metricsMapping = Collections.emptyList();
    private List<MetricMapping> overrideMetricsMapping = Collections.emptyList();

    PrometheusExporterConfigurationProperties() {
    }

    public List<MetricMapping> getMetricsMapping() {
        ArrayList<MetricMapping> result = new ArrayList<MetricMapping>(this.metricsMapping.size() + this.overrideMetricsMapping.size());
        result.addAll(this.metricsMapping);
        result.addAll(this.overrideMetricsMapping);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTimeStampEnabled() {
        return this.timeStampEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<@NotBlank String> getAllowList() {
        return this.allowList;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<@NotBlank String> getDenyList() {
        return this.denyList;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<PrometheusMetricPrinter.PrinterVersion> getPrinters() {
        return this.printers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<MetricMapping> getOverrideMetricsMapping() {
        return this.overrideMetricsMapping;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTimeStampEnabled(boolean timeStampEnabled) {
        this.timeStampEnabled = timeStampEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAllowList(Set<@NotBlank String> allowList) {
        this.allowList = allowList;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDenyList(Set<@NotBlank String> denyList) {
        this.denyList = denyList;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPrinters(Set<PrometheusMetricPrinter.PrinterVersion> printers) {
        this.printers = printers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMetricsMapping(List<MetricMapping> metricsMapping) {
        this.metricsMapping = metricsMapping;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOverrideMetricsMapping(List<MetricMapping> overrideMetricsMapping) {
        this.overrideMetricsMapping = overrideMetricsMapping;
    }
}

