/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.DataPointsReceivedEvent;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.TagsBuilder;
import com.hazelcast.webmonitor.prometheus.EventReceiverProvider;
import com.hazelcast.webmonitor.prometheus.PrometheusEntry;
import java.util.Map;
import java.util.function.Predicate;

class DataPointsProvider
extends EventReceiverProvider<DataPointsReceivedEvent> {
    private static final int TTL_IN_SECONDS = 90;
    private final Predicate<MetricDataPoint> filter;

    DataPointsProvider(Predicate<MetricDataPoint> filter) {
        super(90);
        this.filter = filter;
    }

    void updateResults(DataPointsReceivedEvent event) {
        String clusterName = event.getMemberIdent().getClusterName();
        for (MetricDataPoint dataPoint : event.getDataPoints()) {
            if (!this.filter.test(dataPoint)) continue;
            Map tags = TagsBuilder.tagsBuilderFrom((Map)dataPoint.getTags()).with("mc_cluster", clusterName).buildStringMap();
            long dataPointTime = dataPoint.getTime();
            this.results.asMap().compute(new PrometheusEntry.Key(dataPoint.getName(), tags, dataPoint.getUnit()), (k, v) -> {
                if (v == null || v.time() < dataPointTime) {
                    double value = dataPoint.getType() == DataPointType.DOUBLE ? dataPoint.getDoubleValue() : (double)dataPoint.getValue();
                    return new PrometheusEntry.Value(dataPointTime, value);
                }
                return v;
            });
        }
    }
}

