/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Tag;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
final class RegistryKeySerializer {
    private static final ThreadLocal<String[]> ORDERED_TAGS = ThreadLocal.withInitial(() -> new String[Tag.values().length * 2]);
    private static final byte NON_NIL_KEY_FLAG = 0;

    private RegistryKeySerializer() {
        throw new IllegalStateException("Should never be instantiated");
    }

    static int serialize(@Nonnull String metric, @Nonnull Map<String, String> tags, ByteBuffer dest) {
        dest.clear();
        RegistryKeySerializer.writeHeaderAndMetricName((String)metric, (ByteBuffer)dest);
        String[] orderedTags = RegistryKeySerializer.getEmptyArrayForTags();
        int tagsCount = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String tagName = entry.getKey();
            if (!Tag.isPersisted((String)tagName)) continue;
            int nameIndex = Tag.forName((String)tagName).ordinal() * 2;
            orderedTags[nameIndex] = tagName;
            orderedTags[nameIndex + 1] = entry.getValue();
            ++tagsCount;
        }
        RegistryKeySerializer.writeTags((ByteBuffer)dest, (int)tagsCount, (String[])orderedTags);
        dest.flip();
        return dest.limit();
    }

    static int serialize(@Nonnull Metric metric, @Nonnull Map<Tag, String> tags, ByteBuffer dest) {
        dest.clear();
        RegistryKeySerializer.writeHeaderAndMetricName((String)metric.getName(), (ByteBuffer)dest);
        String[] orderedTags = RegistryKeySerializer.getEmptyArrayForTags();
        int tagsCount = 0;
        for (Map.Entry<Tag, String> entry : tags.entrySet()) {
            Tag tag = entry.getKey();
            if (!tag.isPersisted()) continue;
            int nameIndex = tag.ordinal() * 2;
            orderedTags[nameIndex] = tag.getName();
            orderedTags[nameIndex + 1] = entry.getValue();
            ++tagsCount;
        }
        RegistryKeySerializer.writeTags((ByteBuffer)dest, (int)tagsCount, (String[])orderedTags);
        dest.flip();
        return dest.limit();
    }

    @Nonnull
    private static String[] getEmptyArrayForTags() {
        Object[] orderedTags = (String[])ORDERED_TAGS.get();
        Arrays.fill(orderedTags, null);
        return orderedTags;
    }

    private static void writeHeaderAndMetricName(@Nonnull String metric, ByteBuffer dest) {
        dest.put((byte)0);
        RegistryKeySerializer.writeStringUsingIntPerEachChar((String)metric, (ByteBuffer)dest);
    }

    private static void writeTags(ByteBuffer dest, int tagsCount, String[] orderedTags) {
        dest.putInt(tagsCount);
        for (int i = 0; i < orderedTags.length; i += 2) {
            String tagName = orderedTags[i];
            if (tagName == null) continue;
            RegistryKeySerializer.writeStringUsingIntPerEachChar((String)tagName, (ByteBuffer)dest);
            RegistryKeySerializer.writeStringUsingIntPerEachChar((String)orderedTags[i + 1], (ByteBuffer)dest);
        }
    }

    private static void writeStringUsingIntPerEachChar(@Nonnull String str, @Nonnull ByteBuffer dest) {
        int strLen = str.length();
        dest.putInt(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            dest.putInt(c);
        }
    }
}

