/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteBucket;
import com.hazelcast.webmonitor.service.Clock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PassiveExpiringSet<I extends MinuteBucket> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PassiveExpiringSet.class);
    private static final float MAP_LOAD_FACTOR = 0.9f;
    private final ConcurrentMap<I, Long> items;
    private final Clock clock;
    private final long ttlNs;
    private final Function<I, Long> timeFunction;

    PassiveExpiringSet(Clock clock, long ttlNs, int initialCapacity) {
        this.clock = clock;
        this.timeFunction = item -> clock.nanoTime();
        this.ttlNs = ttlNs;
        this.items = new ConcurrentHashMap(initialCapacity, 0.9f);
    }

    void put(I item) {
        this.items.computeIfAbsent(item, this.timeFunction);
    }

    List<I> pollExpired() {
        long thresholdNs = this.clock.nanoTime() - this.ttlNs;
        int limit = this.size();
        ArrayList<MinuteBucket> result = new ArrayList<MinuteBucket>(limit);
        Iterator it = this.items.entrySet().iterator();
        while (it.hasNext() && result.size() < limit) {
            Map.Entry entry = it.next();
            if ((Long)entry.getValue() > thresholdNs) continue;
            MinuteBucket bucket = (MinuteBucket)entry.getKey();
            result.add(bucket);
            bucket.untrack();
            it.remove();
        }
        log.debug("#pollExpired(): set size before {}, set size after {}, expired buckets size {}", new Object[]{limit, this.size(), result.size()});
        return result;
    }

    List<I> pollAll() {
        ArrayList<MinuteBucket> result = new ArrayList<MinuteBucket>(this.items.size());
        Iterator it = this.items.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            MinuteBucket bucket = (MinuteBucket)entry.getKey();
            result.add(bucket);
            bucket.untrack();
            it.remove();
        }
        return result;
    }

    int size() {
        return this.items.size();
    }
}

