/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteBucket;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBTimeUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinuteSeries {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MinuteSeries.class);
    static final int NUMBER_OF_BUCKETS = 3;
    final List<MinuteBucket> buckets = new ArrayList(3);

    MinuteSeries(int metricId) {
        for (int i = 0; i < 3; ++i) {
            this.buckets.add(new MinuteBucket(metricId, this));
        }
    }

    synchronized long[] findValues(long minuteStart) {
        for (MinuteBucket bucket : this.buckets) {
            if (bucket.released || bucket.minuteStart != minuteStart) continue;
            return bucket.values();
        }
        return null;
    }

    MinuteBucket put(int metricId, long time, long value) {
        long minuteStart = RocksDBTimeUtil.minuteStart((long)time);
        for (MinuteBucket bucket : this.buckets) {
            if (bucket.released || bucket.metricId != metricId || bucket.minuteStart != minuteStart) continue;
            if (!bucket.untracked) {
                bucket.put(time, value);
                return bucket;
            }
            return null;
        }
        for (MinuteBucket bucket : this.buckets) {
            if (!bucket.released || !bucket.untracked) continue;
            bucket.putIfAvailable(time, value);
            return bucket;
        }
        MinuteBucket bucket = new MinuteBucket(metricId, this);
        bucket.putIfAvailable(time, value);
        this.buckets.add(bucket);
        return bucket;
    }

    synchronized boolean isEmpty() {
        return this.buckets.stream().allMatch(it -> it.released);
    }

    void removeBucketIfSizeExceeds(MinuteBucket bucket) {
        if (this.buckets.size() > 3) {
            this.buckets.remove(bucket);
        }
    }
}

