/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl;

import com.hazelcast.webmonitor.metrics.ClosedStorageException;
import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.metrics.Query;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricsStorage
implements MetricsStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMetricsStorage.class);
    private volatile boolean closed;

    public void store(String cluster, List<MetricDataPoint> dataPoints) {
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster must be set");
        }
        if (dataPoints == null) {
            throw new IllegalArgumentException("Data points collection must be set");
        }
        if (this.closed) {
            throw new ClosedStorageException();
        }
        this.doStore(cluster, dataPoints);
    }

    protected abstract void doStore(@Nonnull String var1, @Nonnull List<MetricDataPoint> var2);

    public DataPointSeries queryRange(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (this.closed) {
            throw new ClosedStorageException();
        }
        return this.doQueryRange(query);
    }

    protected abstract DataPointSeries doQueryRange(@Nonnull Query var1);

    public Optional<DataPointAware> queryLatest(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (this.closed) {
            throw new ClosedStorageException();
        }
        return this.doQueryLatest(query);
    }

    protected abstract Optional<DataPointAware> doQueryLatest(@Nonnull Query var1);

    public Set<String> getMonitoredClusters() {
        if (this.closed) {
            throw new ClosedStorageException();
        }
        return this.doGetMonitoredClusters();
    }

    protected abstract Set<String> doGetMonitoredClusters();

    public long countStoredDataPoints(String cluster) {
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster must be set");
        }
        return this.doCountStoredDataPoints(cluster);
    }

    protected abstract long doCountStoredDataPoints(@Nonnull String var1);

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        try {
            this.closed = true;
            this.doClose();
            log.debug("Closed metrics storage successfully.");
        }
        catch (Exception e) {
            log.error("Could not close metrics storage.", (Throwable)e);
        }
    }

    protected abstract void doClose() throws Exception;
}

