/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Tag;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsTraceLogger {
    private final MetricsConfigurationProperties metricsConfigurationProperties;
    private final Logger logger;

    public MetricsTraceLogger(MetricsConfigurationProperties metricsConfigurationProperties) {
        this.metricsConfigurationProperties = metricsConfigurationProperties;
        this.logger = LoggerFactory.getLogger((String)"MetricsTrace");
    }

    public void trace(String cluster, List<MetricDataPoint> metricDataPoints, String message) {
        if (!this.metricsConfigurationProperties.getTraceMetrics().isEmpty()) {
            metricDataPoints.forEach(metricDataPoint -> this.trace(cluster, metricDataPoint, message));
        }
    }

    public void trace(String cluster, MetricDataPoint metricDataPoint, String message) {
        this.trace(cluster, metricDataPoint.getName(), metricDataPoint.getTags(), metricDataPoint.getTime(), (double)metricDataPoint.getValue(), message);
    }

    public void trace(String cluster, String metric, Map<String, String> tags, long metricTime, double metricValue, String message) {
        if (this.metricsConfigurationProperties.getTraceMetrics().contains(metric)) {
            this.logger.trace("{} for metric={}, cluster={}, member={}, metricTime={}, value={}", new Object[]{message, metric, cluster, this.getMember(tags), metricTime, metricValue});
        }
    }

    private String getMember(Map<String, String> tags) {
        return StringUtils.defaultString((String)tags.get(Tag.MEMBER.getName()));
    }

    @ConstructorProperties(value={"metricsConfigurationProperties", "logger"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsTraceLogger(MetricsConfigurationProperties metricsConfigurationProperties, Logger logger) {
        this.metricsConfigurationProperties = metricsConfigurationProperties;
        this.logger = logger;
    }
}

