/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.config.properties.FlowConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.service.telemetry.PendoDataSupplier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletContext;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class UiController {
    private final PendoDataSupplier pendoDataSupplier;
    private final MCConfigurationProperties mcProperties;
    private final FlowConfigurationProperties flowConfigurationProperties;
    private final ServletContext servletContext;
    private final WebProperties webProperties;

    @GetMapping(path={"/login.html"}, produces={"text/html"})
    public String serveLogin() {
        return "login";
    }

    @GetMapping(path={"/**"}, produces={"text/html"})
    public String serveMain() {
        return "main";
    }

    @GetMapping(path={"/mcbootstrap.js"}, produces={"application/javascript"})
    public String serveMCBootstrapJS(Model model) {
        model.addAttribute("mcVersion", (Object)BuildInfo.getFullVersion());
        model.addAttribute("staticResourcesVersion", (Object)this.webProperties.getResources().getChain().getStrategy().getFixed().getVersion());
        model.addAttribute("pendoData", (Object)this.pendoDataSupplier.get());
        boolean isInternalCloudMode = this.mcProperties.getInternal().isCloud();
        model.addAttribute("isInternalCloudMode", (Object)isInternalCloudMode);
        List flowAddresses = this.flowConfigurationProperties.getAddresses();
        String firstFlowAddress = flowAddresses == null ? "" : (String)flowAddresses.get(0);
        model.addAttribute("flowAddress", (Object)firstFlowAddress);
        String contextPath = this.servletContext.getContextPath();
        model.addAttribute("contextPath", (Object)contextPath);
        boolean isOldConsoleEnabled = this.mcProperties.isOriginalConsoleEnabled();
        model.addAttribute("isOldConsoleEnabled", (Object)isOldConsoleEnabled);
        return "mcbootstrap.js";
    }

    @GetMapping(path={"/swagger-ui/index.html"}, produces={"text/html"})
    public String serveSwaggerUi() {
        return "swagger-ui";
    }

    @ConstructorProperties(value={"pendoDataSupplier", "mcProperties", "flowConfigurationProperties", "servletContext", "webProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UiController(PendoDataSupplier pendoDataSupplier, MCConfigurationProperties mcProperties, FlowConfigurationProperties flowConfigurationProperties, ServletContext servletContext, WebProperties webProperties) {
        this.pendoDataSupplier = pendoDataSupplier;
        this.mcProperties = mcProperties;
        this.flowConfigurationProperties = flowConfigurationProperties;
        this.servletContext = servletContext;
        this.webProperties = webProperties;
    }
}

