/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.google.common.base.Suppliers;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.webmonitor.controller.internal.SwaggerUIConfigController;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.resource.ResourceUrlProvider;

@RestController
@RequestMapping(path={"/api"})
public class SwaggerUIConfigController {
    private static final String STATIC_DIR = "static";
    private static final String OPENAPI_DIR = "openapi";
    private final ResourcePatternResolver resolver;
    private final ResourceUrlProvider resourceUrlProvider;
    private final Supplier<PartialSwaggerUIConfigDTO> memoizedConfig = Suppliers.memoize(() -> this.getSwaggerUiConfig());

    @GetMapping(value={"/swagger-ui/config"})
    public PartialSwaggerUIConfigDTO listOpenAPIDefinitionPaths() {
        return (PartialSwaggerUIConfigDTO)this.memoizedConfig.get();
    }

    private PartialSwaggerUIConfigDTO getSwaggerUiConfig() {
        String locationPattern = "%s%s/%s/*.yaml".formatted("classpath:", STATIC_DIR, OPENAPI_DIR);
        return Arrays.stream(this.resolver.getResources(locationPattern)).map(arg_0 -> this.toDefinitionDTO(arg_0)).collect(Collectors.collectingAndThen(Collectors.toUnmodifiableList(), PartialSwaggerUIConfigDTO::new));
    }

    private PartialSwaggerUIConfigDTO.OpenAPIDefinitionDTO toDefinitionDTO(Resource resource) {
        YamlMapping mapping = (YamlMapping)YamlLoader.load((InputStream)resource.getInputStream());
        String title = mapping.childAsMapping("info").childAsScalar("title").nodeValue().toString();
        String lookupPath = "/%s/%s/%s".formatted(STATIC_DIR, OPENAPI_DIR, resource.getFilename());
        String url = this.resourceUrlProvider.getForLookupPath(lookupPath);
        return new PartialSwaggerUIConfigDTO.OpenAPIDefinitionDTO(title, url);
    }

    @ConstructorProperties(value={"resolver", "resourceUrlProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SwaggerUIConfigController(ResourcePatternResolver resolver, ResourceUrlProvider resourceUrlProvider) {
        this.resolver = resolver;
        this.resourceUrlProvider = resourceUrlProvider;
    }
}

