/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.controller.dto.UserInfoDTO;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class SelfController {
    private final UserDAO userDAO;

    @GetMapping(path={"/self"})
    public UserInfoDTO self() {
        String username = SecurityContextUtil.getUsername();
        List roles = SecurityContextUtil.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        Optional lastLoginTime = this.userDAO.getLastLoginTime(username);
        long lastLoginTimeMillis = lastLoginTime.map(time -> time.toInstant().toEpochMilli()).orElse(0L);
        return new UserInfoDTO(username, roles, lastLoginTimeMillis);
    }

    @ConstructorProperties(value={"userDAO"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SelfController(UserDAO userDAO) {
        this.userDAO = userDAO;
    }
}

