/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.controller.dto.metrics.MetricsDebugDataDTO;
import com.hazelcast.webmonitor.controller.internal.MetricSettingsDTO;
import com.hazelcast.webmonitor.metrics.MetricsDebuggerService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class MetricsDebuggerController {
    private final MetricsDebuggerService debuggerService;

    @GetMapping(value={"/metrics-debugger/stats"})
    public MetricsDebugDataDTO handleStats() {
        return this.debuggerService.dumpStatus();
    }

    @PostMapping(value={"/metrics-debugger/settings"})
    public MetricSettingsDTO handleDebuggerSettings(@Valid @RequestBody MetricSettingsDTO dto) {
        if (dto.isSamplingEnabled()) {
            this.debuggerService.startSampling();
        } else {
            this.debuggerService.stopSampling();
        }
        return dto;
    }

    @ConstructorProperties(value={"debuggerService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MetricsDebuggerController(MetricsDebuggerService debuggerService) {
        this.debuggerService = debuggerService;
    }
}

