/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.healthcheck.AddIgnoreListEntryRequestDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.EventPublishingHealthCheckService;
import com.hazelcast.webmonitor.service.healthcheck.HealthcheckStatus;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.Map;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/clusters/{cluster}/health"})
public class HealthCheckController
extends BaseInternalController {
    private final EventPublishingHealthCheckService service;

    public HealthCheckController(EventPublishingHealthCheckService service, StateManager stateManager, AuditLogService auditService) {
        super(stateManager, auditService);
        this.service = service;
    }

    @GetMapping
    @Secured(value={"ROLE_ADMIN", "ROLE_CLOUD_USER"})
    public Collection<AnalysisOutcome> performHealthCheck(@PathVariable String cluster, @RequestParam(defaultValue="false") boolean runFullCheck) {
        return this.service.analyze(cluster, runFullCheck);
    }

    @GetMapping(value={"/count"})
    public Map<HealthcheckStatus, Long> getHealthcheckStatusCounts(@PathVariable String cluster) {
        return this.service.getHealthcheckStatusCounts(cluster);
    }

    @PostMapping(value={"/ignore-list"})
    public AddIgnoreListEntryRequestDTO addIgnoreListEntry(@PathVariable String cluster, @Valid @RequestBody AddIgnoreListEntryRequestDTO request, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.service.addIgnoreListEntry(cluster, request);
        return request;
    }

    @DeleteMapping(value={"/ignore-list"})
    public void resetHealthcheckSettings(@PathVariable String cluster) {
        this.service.resetClusterHealthcheckSettings(cluster);
    }
}

