/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.config.conditions.ConditionalOnBranding;
import com.hazelcast.webmonitor.service.FlowConfigService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/flow"})
@ConditionalOnBranding(value="flow")
public class FlowConfigController {
    private final FlowConfigService flowConfigService;

    @GetMapping(value={"/address"})
    public String getFlowAddress() {
        return this.flowConfigService.getFirstFlowAddress();
    }

    @GetMapping(value={"/addresses"})
    public List<String> getFlowAddresses() {
        return this.flowConfigService.getFlowAddresses();
    }

    @PostMapping(value={"/addresses"})
    @Secured(value={"ROLE_ADMIN"})
    public void setFlowAddresses(@RequestBody List<String> flowAddresses) {
        this.flowConfigService.setFlowAddresses(flowAddresses);
    }

    @ConstructorProperties(value={"flowConfigService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FlowConfigController(FlowConfigService flowConfigService) {
        this.flowConfigService = flowConfigService;
    }
}

