/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.dto;

import com.hazelcast.webmonitor.utils.StatisticsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public final class HeapMemoryDistributionDTO {
    private final long committedHeap;
    private final long usedHeap;
    private final long mapsHeapCost;
    private final double map;
    private final double other;
    private final double free;

    public HeapMemoryDistributionDTO(long committedHeap, long usedHeap, long mapsHeapCost) {
        this.committedHeap = committedHeap;
        this.usedHeap = usedHeap;
        this.mapsHeapCost = mapsHeapCost;
        this.map = StatisticsUtil.asPercents((double)mapsHeapCost, (double)committedHeap);
        this.other = StatisticsUtil.asPercents((double)((double)usedHeap - (double)mapsHeapCost), (double)committedHeap);
        this.free = StatisticsUtil.asPercents((double)((double)committedHeap - (double)usedHeap), (double)committedHeap);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getCommittedHeap() {
        return this.committedHeap;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getUsedHeap() {
        return this.usedHeap;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMapsHeapCost() {
        return this.mapsHeapCost;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getMap() {
        return this.map;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getOther() {
        return this.other;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getFree() {
        return this.free;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeapMemoryDistributionDTO)) {
            return false;
        }
        HeapMemoryDistributionDTO other = (HeapMemoryDistributionDTO)o;
        if (this.getCommittedHeap() != other.getCommittedHeap()) {
            return false;
        }
        if (this.getUsedHeap() != other.getUsedHeap()) {
            return false;
        }
        if (this.getMapsHeapCost() != other.getMapsHeapCost()) {
            return false;
        }
        if (Double.compare(this.getMap(), other.getMap()) != 0) {
            return false;
        }
        if (Double.compare(this.getOther(), other.getOther()) != 0) {
            return false;
        }
        return Double.compare(this.getFree(), other.getFree()) == 0;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $committedHeap = this.getCommittedHeap();
        result = result * 59 + (int)($committedHeap >>> 32 ^ $committedHeap);
        long $usedHeap = this.getUsedHeap();
        result = result * 59 + (int)($usedHeap >>> 32 ^ $usedHeap);
        long $mapsHeapCost = this.getMapsHeapCost();
        result = result * 59 + (int)($mapsHeapCost >>> 32 ^ $mapsHeapCost);
        long $map = Double.doubleToLongBits(this.getMap());
        result = result * 59 + (int)($map >>> 32 ^ $map);
        long $other = Double.doubleToLongBits(this.getOther());
        result = result * 59 + (int)($other >>> 32 ^ $other);
        long $free = Double.doubleToLongBits(this.getFree());
        result = result * 59 + (int)($free >>> 32 ^ $free);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "HeapMemoryDistributionDTO(committedHeap=" + this.getCommittedHeap() + ", usedHeap=" + this.getUsedHeap() + ", mapsHeapCost=" + this.getMapsHeapCost() + ", map=" + this.getMap() + ", other=" + this.getOther() + ", free=" + this.getFree() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HeapMemoryDistributionDTO() {
        this.committedHeap = 0L;
        this.usedHeap = 0L;
        this.mapsHeapCost = 0L;
        this.map = 0.0;
        this.other = 0.0;
        this.free = 0.0;
    }
}

