/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.dto;

import com.hazelcast.webmonitor.controller.dto.CPSubsystemStatusDTO;
import com.hazelcast.webmonitor.utils.StatisticsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;

public final class CPSubsystemStatusDTO {
    private final Status status;
    private final int configuredCount;
    private final int reachableCount;

    public static CPSubsystemStatusDTO fromStats(int configured, int reachable, boolean isCPDataStructurePresent) {
        if (configured == 0) {
            if (isCPDataStructurePresent) {
                return new CPSubsystemStatusDTO(Status.UNSAFE, 0, 0);
            }
            return new CPSubsystemStatusDTO(Status.DISABLED, 0, 0);
        }
        int unreachable = configured - reachable;
        int majority = StatisticsUtil.calculateCPMajority((int)configured);
        if (unreachable >= majority) {
            return new CPSubsystemStatusDTO(Status.MAJORITY_LOST, configured, reachable);
        }
        if (unreachable == majority - 1) {
            return new CPSubsystemStatusDTO(Status.MINORITY_LOST, configured, reachable);
        }
        if (unreachable > 1 && unreachable < majority - 1) {
            return new CPSubsystemStatusDTO(Status.UNREACHABLE_MEMBERS, configured, reachable);
        }
        if (unreachable == 1) {
            return new CPSubsystemStatusDTO(Status.UNREACHABLE_MEMBER, configured, reachable);
        }
        return new CPSubsystemStatusDTO(Status.OK, configured, reachable);
    }

    public static CPSubsystemStatusDTO unknown() {
        return new CPSubsystemStatusDTO(Status.UNKNOWN, -1, -1);
    }

    @ConstructorProperties(value={"status", "configuredCount", "reachableCount"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CPSubsystemStatusDTO(Status status, int configuredCount, int reachableCount) {
        this.status = status;
        this.configuredCount = configuredCount;
        this.reachableCount = reachableCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Status getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getConfiguredCount() {
        return this.configuredCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getReachableCount() {
        return this.reachableCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CPSubsystemStatusDTO)) {
            return false;
        }
        CPSubsystemStatusDTO other = (CPSubsystemStatusDTO)o;
        if (this.getConfiguredCount() != other.getConfiguredCount()) {
            return false;
        }
        if (this.getReachableCount() != other.getReachableCount()) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConfiguredCount();
        result = result * 59 + this.getReachableCount();
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CPSubsystemStatusDTO(status=" + String.valueOf(this.getStatus()) + ", configuredCount=" + this.getConfiguredCount() + ", reachableCount=" + this.getReachableCount() + ")";
    }
}

