/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config.properties;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import lombok.Generated;
import org.hibernate.validator.constraints.time.DurationMin;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="hazelcast.mc.metrics")
public class MetricsConfigurationProperties {
    public static final int DEFAULT_DISK_TTL_DAYS = 1;
    public static final int DEFAULT_ACCUMULATION_SECONDS = 70;
    public static final int DEFAULT_PERSISTENCE_RUNS_INTERVAL_MS = 10000;
    public static final int DEFAULT_CONSUMER_THREAD_POOL_SIZE = 2;
    public static final int DEFAULT_CONSUMER_RESCHEDULE_DELAY_MS = 1000;
    public static final int DEFAULT_ON_ERROR_DELAY_MULTIPLIER = 5;
    public static final int DEFAULT_STATE_RESCHEDULE_DELAY_MS = 1000;
    public static final int DEFAULT_JET_METRICS_RETENTION_SECONDS = 3600;
    @Value(value="${hazelcast.mc.metrics.persistence.enabled:true}")
    private boolean persistenceEnabled = true;
    @DurationUnit(value=ChronoUnit.SECONDS)
    @DurationMin(seconds=70L)
    @Value(value="${hazelcast.mc.metrics.accumulation.period.seconds:70}")
    private @DurationMin(seconds=70L) Duration accumulationPeriod = Duration.ofSeconds(70L);
    @DurationUnit(value=ChronoUnit.DAYS)
    @DurationMin(seconds=1L)
    @Value(value="${hazelcast.mc.metrics.disk.ttl.duration:${hazelcast.mc.metrics.disk.ttl.days:1}}")
    private @DurationMin(seconds=1L) Duration diskTtl = Duration.ofDays(1L);
    @Value(value="${hazelcast.mc.metrics.consumer.thread.pool.size:#{null}}")
    private Integer consumerThreadPoolSize = Math.max(ForkJoinPool.getCommonPoolParallelism(), 2);
    @DurationUnit(value=ChronoUnit.MILLIS)
    @Value(value="${hazelcast.mc.metrics.reschedule.delay.millis:1000}")
    private Duration consumerRescheduleDelay = Duration.ofMillis(1000L);
    @DurationUnit(value=ChronoUnit.MILLIS)
    @Value(value="${hazelcast.mc.state.reschedule.delay.millis:1000}")
    private Duration stateRescheduleDelay = Duration.ofMillis(1000L);
    @Value(value="${hazelcast.mc.jet.metrics.retentionSecs:3600}")
    private int jetRetentionSeconds = 3600;
    private Set<String> traceMetrics = Collections.emptySet();

    public Duration getConsumerRescheduleOnErrorDelay() {
        return Duration.ofMillis(this.consumerRescheduleDelay.toMillis() * 5L);
    }

    public Duration getStateRescheduleOnErrorDelay() {
        return Duration.ofMillis(this.stateRescheduleDelay.toMillis() * 5L);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getAccumulationPeriod() {
        return this.accumulationPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getDiskTtl() {
        return this.diskTtl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getConsumerThreadPoolSize() {
        return this.consumerThreadPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getConsumerRescheduleDelay() {
        return this.consumerRescheduleDelay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getStateRescheduleDelay() {
        return this.stateRescheduleDelay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getJetRetentionSeconds() {
        return this.jetRetentionSeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> getTraceMetrics() {
        return this.traceMetrics;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPersistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAccumulationPeriod(Duration accumulationPeriod) {
        this.accumulationPeriod = accumulationPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDiskTtl(Duration diskTtl) {
        this.diskTtl = diskTtl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConsumerThreadPoolSize(Integer consumerThreadPoolSize) {
        this.consumerThreadPoolSize = consumerThreadPoolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConsumerRescheduleDelay(Duration consumerRescheduleDelay) {
        this.consumerRescheduleDelay = consumerRescheduleDelay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStateRescheduleDelay(Duration stateRescheduleDelay) {
        this.stateRescheduleDelay = stateRescheduleDelay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setJetRetentionSeconds(int jetRetentionSeconds) {
        this.jetRetentionSeconds = jetRetentionSeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTraceMetrics(Set<String> traceMetrics) {
        this.traceMetrics = traceMetrics;
    }
}

