/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config.properties;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="hazelcast.mc")
public class MCConfigurationProperties {
    public static final int DEFAULT_MAX_DISABLE_LOGIN_DURATION = Integer.MAX_VALUE;
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final EnumSet<ClientFilteringListType> DEFAULT_CLIENT_FILTERING_MODES = EnumSet.allOf(ClientFilteringListType.class);
    public static final Integer CLC_COMMAND_TIMEOUT = 120;
    private Path home;
    @Value(value="${hazelcast.mc.lock.skip:false}")
    private boolean skipLocking;
    private String license;
    @Value(value="${hazelcast.mc.http.port}")
    private int httpPort = 8080;
    private InetAddress hostAddress;
    @Value(value="${hazelcast.mc.https.port}")
    private int httpsPort;
    @NestedConfigurationProperty
    private TLS tls = new TLS();
    @Value(value="${hazelcast.mc.include.cipher.suites:#{null}}")
    private String[] includeCipherSuites;
    @Value(value="${hazelcast.mc.exclude.cipher.suites:#{null}}")
    private String[] excludeCipherSuites;
    @Value(value="${hazelcast.mc.cluster.operation.timeout.millis}")
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration clusterOperationTimeout = Duration.ofMinutes(1L);
    @Value(value="${hazelcast.mc.forwarded.requests.enabled}")
    private boolean forwardedRequestsEnabled;
    @Value(value="${hazelcast.mc.healthCheck.port}")
    private int healthCheckPort;
    private boolean allowMultipleLogin = true;
    private String contextPath;
    private boolean forceLogoutOnMultipleLogin;
    private int initialDisableLoginPeriod = 5;
    private int disableLoginPeriodMultiplier = 10;
    private int failedAttemptsBeforeDisableLogin = 3;
    private int maxDisableLoginPeriod = Integer.MAX_VALUE;
    @Value(value="${hazelcast.mc.ui.asyncTableThreshold}")
    private int asyncTableThreshold;
    @Value(value="${hazelcast.mc.original.console.enabled:false}")
    private boolean originalConsoleEnabled;
    @Value(value="${hazelcast.mc.clc.command.timeout.seconds:#{T(com.hazelcast.webmonitor.config.properties.MCConfigurationProperties).CLC_COMMAND_TIMEOUT}}")
    private int clcCommandTimeoutSeconds;
    @Value(value="${hazelcast.mc.internal.member.warnings.enabled:#{null}}")
    private Boolean internalMemberWarningsEnabled;
    @Value(value="${hazelcast.mc.disable.csrf:false}")
    private boolean disableCsrf;
    private boolean useExistingKeyStore;
    @Value(value="${hazelcast.mc.clientFiltering.modes:#{T(com.hazelcast.webmonitor.config.properties.MCConfigurationProperties).DEFAULT_CLIENT_FILTERING_MODES}}")
    private EnumSet<ClientFilteringListType> clientFilteringModes = DEFAULT_CLIENT_FILTERING_MODES;
    @NestedConfigurationProperty
    private ExistingKeyStore existingKeyStore = new ExistingKeyStore();
    @NestedConfigurationProperty
    private BuiltInKeyStore keyStore = new BuiltInKeyStore();
    @NestedConfigurationProperty
    private Toggle auditLog = new Toggle();
    @NestedConfigurationProperty
    private Toggle rest = new Toggle();
    @NestedConfigurationProperty
    private Internal internal = new Internal(this);

    public String getRootUrl() {
        return (this.tls.enabled ? "https" : "http") + "://" + (this.hostAddress == null ? "localhost" : this.hostAddress.getHostAddress()) + ":" + this.getPort() + this.contextPath;
    }

    public int getPort() {
        return this.tls.enabled ? this.httpsPort : this.httpPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getHome() {
        return this.home;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSkipLocking() {
        return this.skipLocking;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLicense() {
        return this.license;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getHttpPort() {
        return this.httpPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getHttpsPort() {
        return this.httpsPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TLS getTls() {
        return this.tls;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String[] getIncludeCipherSuites() {
        return this.includeCipherSuites;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String[] getExcludeCipherSuites() {
        return this.excludeCipherSuites;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getClusterOperationTimeout() {
        return this.clusterOperationTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isForwardedRequestsEnabled() {
        return this.forwardedRequestsEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getHealthCheckPort() {
        return this.healthCheckPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAllowMultipleLogin() {
        return this.allowMultipleLogin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getContextPath() {
        return this.contextPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isForceLogoutOnMultipleLogin() {
        return this.forceLogoutOnMultipleLogin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getInitialDisableLoginPeriod() {
        return this.initialDisableLoginPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getDisableLoginPeriodMultiplier() {
        return this.disableLoginPeriodMultiplier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getFailedAttemptsBeforeDisableLogin() {
        return this.failedAttemptsBeforeDisableLogin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxDisableLoginPeriod() {
        return this.maxDisableLoginPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getAsyncTableThreshold() {
        return this.asyncTableThreshold;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isOriginalConsoleEnabled() {
        return this.originalConsoleEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getClcCommandTimeoutSeconds() {
        return this.clcCommandTimeoutSeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDisableCsrf() {
        return this.disableCsrf;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseExistingKeyStore() {
        return this.useExistingKeyStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnumSet<ClientFilteringListType> getClientFilteringModes() {
        return this.clientFilteringModes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExistingKeyStore getExistingKeyStore() {
        return this.existingKeyStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BuiltInKeyStore getKeyStore() {
        return this.keyStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Toggle getAuditLog() {
        return this.auditLog;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Toggle getRest() {
        return this.rest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Internal getInternal() {
        return this.internal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHome(Path home) {
        this.home = home;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSkipLocking(boolean skipLocking) {
        this.skipLocking = skipLocking;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLicense(String license) {
        this.license = license;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHostAddress(InetAddress hostAddress) {
        this.hostAddress = hostAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTls(TLS tls) {
        this.tls = tls;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setIncludeCipherSuites(String[] includeCipherSuites) {
        this.includeCipherSuites = includeCipherSuites;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExcludeCipherSuites(String[] excludeCipherSuites) {
        this.excludeCipherSuites = excludeCipherSuites;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClusterOperationTimeout(Duration clusterOperationTimeout) {
        this.clusterOperationTimeout = clusterOperationTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setForwardedRequestsEnabled(boolean forwardedRequestsEnabled) {
        this.forwardedRequestsEnabled = forwardedRequestsEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setHealthCheckPort(int healthCheckPort) {
        this.healthCheckPort = healthCheckPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAllowMultipleLogin(boolean allowMultipleLogin) {
        this.allowMultipleLogin = allowMultipleLogin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setForceLogoutOnMultipleLogin(boolean forceLogoutOnMultipleLogin) {
        this.forceLogoutOnMultipleLogin = forceLogoutOnMultipleLogin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInitialDisableLoginPeriod(int initialDisableLoginPeriod) {
        this.initialDisableLoginPeriod = initialDisableLoginPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDisableLoginPeriodMultiplier(int disableLoginPeriodMultiplier) {
        this.disableLoginPeriodMultiplier = disableLoginPeriodMultiplier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setFailedAttemptsBeforeDisableLogin(int failedAttemptsBeforeDisableLogin) {
        this.failedAttemptsBeforeDisableLogin = failedAttemptsBeforeDisableLogin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxDisableLoginPeriod(int maxDisableLoginPeriod) {
        this.maxDisableLoginPeriod = maxDisableLoginPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAsyncTableThreshold(int asyncTableThreshold) {
        this.asyncTableThreshold = asyncTableThreshold;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOriginalConsoleEnabled(boolean originalConsoleEnabled) {
        this.originalConsoleEnabled = originalConsoleEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClcCommandTimeoutSeconds(int clcCommandTimeoutSeconds) {
        this.clcCommandTimeoutSeconds = clcCommandTimeoutSeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInternalMemberWarningsEnabled(Boolean internalMemberWarningsEnabled) {
        this.internalMemberWarningsEnabled = internalMemberWarningsEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDisableCsrf(boolean disableCsrf) {
        this.disableCsrf = disableCsrf;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUseExistingKeyStore(boolean useExistingKeyStore) {
        this.useExistingKeyStore = useExistingKeyStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientFilteringModes(EnumSet<ClientFilteringListType> clientFilteringModes) {
        this.clientFilteringModes = clientFilteringModes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExistingKeyStore(ExistingKeyStore existingKeyStore) {
        this.existingKeyStore = existingKeyStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setKeyStore(BuiltInKeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAuditLog(Toggle auditLog) {
        this.auditLog = auditLog;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRest(Toggle rest) {
        this.rest = rest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInternal(Internal internal) {
        this.internal = internal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Boolean getInternalMemberWarningsEnabled() {
        return this.internalMemberWarningsEnabled;
    }
}

