/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config.properties;

import com.hazelcast.webmonitor.config.conditions.ConditionalOnBranding;
import com.hazelcast.webmonitor.config.properties.BuildInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="hazelcast.mc.flow")
@ConditionalOnBranding(value="flow")
public class FlowConfigurationProperties {
    public static final String HAZELCAST_MC_APPLICATION_CLIENT_SECRET = "hazelcast.mc.application.client.secret";
    private List<@NotBlank String> addresses;
    private String internalAddress = "";

    @PostConstruct
    void verifyFlowNodeAddressIsConfigured() {
        if (BuildInfo.getBranding().equals("flow") && (this.addresses == null || this.addresses.isEmpty())) {
            throw new IllegalArgumentException("hazelcast.mc.flow.addresses must be configured with at least 1 element.");
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotBlank String> getAddresses() {
        return this.addresses;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getInternalAddress() {
        return this.internalAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAddresses(List<@NotBlank String> addresses) {
        this.addresses = addresses;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setInternalAddress(String internalAddress) {
        this.internalAddress = internalAddress;
    }
}

