/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config.conditions;

import com.hazelcast.webmonitor.config.conditions.ConditionalOnBranding;
import com.hazelcast.webmonitor.config.properties.BuildInfo;
import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

public class BrandingCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String buildInfoBranding = BuildInfo.getBranding();
        Map annotationAttributes = metadata.getAnnotationAttributes(ConditionalOnBranding.class.getName());
        Assert.notNull((Object)annotationAttributes, (String)"Annotation @ConditionalOnBranding not found");
        String annotationBranding = this.getBranding(annotationAttributes);
        return annotationBranding.equals(buildInfoBranding);
    }

    private String getBranding(Map<String, Object> annotationAttributes) {
        String value = (String)annotationAttributes.get("value");
        Assert.state((!value.isEmpty() ? 1 : 0) != 0, (String)"The value attribute of @ConditionalOnBranding must be specified");
        return value;
    }
}

