/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.conditions.ConditionalOnBranding;
import com.hazelcast.webmonitor.controller.dto.EndSessionEndpointWrapper;
import com.hazelcast.webmonitor.service.EndSessionEndpointFetchedEvent;
import com.hazelcast.webmonitor.service.LoggedInToExternalIdpEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@ConditionalOnBranding(value="flow")
@Component
public class OidcExternalIdpLogoutHelper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OidcExternalIdpLogoutHelper.class);
    private final RestTemplate restTemplate;
    private final AtomicReference<String> issuer = new AtomicReference<String>("");
    private final AtomicReference<String> endSessionEndpoint = new AtomicReference<String>("");

    @EventListener
    public void loggedInToExternalIdp(LoggedInToExternalIdpEvent event) {
        this.issuer.set(event.getIssuer());
    }

    @EventListener
    public void endSessionEndpointFetched(EndSessionEndpointFetchedEvent event) {
        this.endSessionEndpoint.set(event.getEndSessionEndpoint());
    }

    @EventListener
    public void httpSessionDestroyed(HttpSessionDestroyedEvent event) {
        this.logoutFromExternalIdp();
    }

    private void logoutFromExternalIdp() {
        try {
            String currentIdToken = this.getIdToken();
            if (currentIdToken.isEmpty()) {
                return;
            }
            String currentIssuer = this.getIssuer();
            if (currentIssuer.isEmpty()) {
                return;
            }
            String currentEndSessionEndpoint = this.getEndSessionEndpoint(currentIssuer);
            if (currentEndSessionEndpoint.isEmpty()) {
                return;
            }
            this.logoutFromExternalIdp(currentEndSessionEndpoint, currentIdToken);
        }
        catch (Exception e) {
            log.warn("Couldn't send OIDC logout request.", (Throwable)e);
        }
    }

    private String getIdToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof OAuth2AuthenticationToken)) {
            log.trace("Couldn't retrieve authentication.");
            return "";
        }
        OAuth2AuthenticationToken authToken = (OAuth2AuthenticationToken)authentication;
        DefaultOidcUser user = (DefaultOidcUser)authToken.getPrincipal();
        String idToken = user.getIdToken().getTokenValue();
        if (idToken.isEmpty()) {
            log.trace("Couldn't retrieve id token.");
        }
        return idToken;
    }

    private String getIssuer() {
        String currentIssuer = (String)this.issuer.get();
        if (currentIssuer.isEmpty()) {
            log.trace("Couldn't retrieve issuer.");
        }
        return currentIssuer;
    }

    private String getEndSessionEndpoint(String issuer) {
        String endpoint = (String)this.endSessionEndpoint.get();
        if (endpoint.isEmpty() && (endpoint = this.fetchEndSessionEndpoint(issuer)).isEmpty()) {
            log.trace("Couldn't fetch end session endpoint.");
        }
        return endpoint;
    }

    private String fetchEndSessionEndpoint(String issuer) {
        String discoveryEndpoint = issuer + "/.well-known/openid-configuration";
        EndSessionEndpointWrapper endSessionEndpointWrapper = null;
        try {
            endSessionEndpointWrapper = (EndSessionEndpointWrapper)this.restTemplate.getForObject(discoveryEndpoint, EndSessionEndpointWrapper.class, new Object[0]);
        }
        catch (Exception e) {
            log.warn("Exception occurred while fetching end session endpoint from the discovery: {}.", (Object)discoveryEndpoint, (Object)e);
        }
        return endSessionEndpointWrapper == null || endSessionEndpointWrapper.getEndSessionEndpoint() == null ? "" : endSessionEndpointWrapper.getEndSessionEndpoint();
    }

    private void logoutFromExternalIdp(String endSessionEndpoint, String idToken) {
        ResponseEntity responseEntity = this.restTemplate.getForEntity(endSessionEndpoint + "?id_token_hint=" + idToken, String.class, new Object[0]);
        log.trace("End session endpoint returned: {}.", responseEntity.getBody());
    }

    @ConstructorProperties(value={"restTemplate"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OidcExternalIdpLogoutHelper(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

