/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseUserTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultSecurityProvider;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.io.PrintWriter;
import java.util.Optional;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Change password for the given user record in the default security provider.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
class UpdateUserPasswordTask
extends BaseUserTask {
    @CommandLine.Option(names={"-n", "--username"}, required=true, paramLabel="<username>", description={"Username for the user record."})
    private String username;
    @CommandLine.Option(names={"-p", "--password"}, paramLabel="<password>", description={"Password for the user record. Provide value directly or use without value to enter securely with interactive prompt. If you're on Linux or MacOS devices and provide value directly to `mc-conf`, please enclose password in single quotes like: -p='mysecr3tp@s$word'"}, arity="0..1", interactive=true)
    private String password;

    UpdateUserPasswordTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        if (StringUtil.isNullOrEmptyAfterTrim((String)this.password)) {
            throw new CliException("Password parameter is not specified. Use --password=<password> or --password without value to enter it with interactive prompt.");
        }
        DefaultSecurityProvider securityProvider = this.initDefaultSecurityProvider(false);
        Optional user = securityProvider.getUser(this.username);
        if (!user.isPresent()) {
            throw new CliException(String.format("User record for username '%s' does not exist.", this.username));
        }
        try {
            securityProvider.changePassword(this.username, this.password);
        }
        catch (Exception e) {
            throw new CliException(String.format("Could not change password. Reason:%n%s", e.getMessage()), (Throwable)e);
        }
        this.printf("Successfully changed password for user '%s'.%n", new Object[]{this.username});
    }
}

