/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.EntityAlreadyExistsException;
import com.hazelcast.webmonitor.prometheus.PrometheusAuthAlreadyConfiguredException;
import com.hazelcast.webmonitor.prometheus.PrometheusAuthDetails;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.service.SettingsService;
import java.io.PrintWriter;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Configures authentication for the Prometheus scrape endpoint (/metrics)"})
public class PrometheusAuthenticationSettingTask
extends BaseCliTask {
    @CommandLine.Parameters(index="0", paramLabel="username")
    private String userName;
    @CommandLine.Parameters(index="1", paramLabel="password")
    private String password;

    public PrometheusAuthenticationSettingTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        PrometheusAuthDetails authDetails = new PrometheusAuthDetails(this.userName, this.password);
        try {
            new SettingsService(new SettingsDAO(this.initJdbi())).savePrometheusAuthDetails(authDetails);
            this.println("Configured authentication for Prometheus scrape endpoint with username " + this.userName);
        }
        catch (PrometheusAuthAlreadyConfiguredException e) {
            throw new EntityAlreadyExistsException(e.getMessage(), "");
        }
    }
}

