/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.SecurityConfigParameter;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Get the current security provider configuration.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
class GetSecurityProviderTask
extends BaseCliTask {
    private static final Set<String> BUILT_IN_SECURITY_PROVIDERS = Set.of("Dev Mode", "Default");
    private static final ObjectWriter OBJECT_WRITER = SerializationUtil.OBJECT_MAPPER.writer().withDefaultPrettyPrinter();

    GetSecurityProviderTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        GroupedSettingsDAO groupedSettingsDAO = new GroupedSettingsDAO(jdbi, settingsDAO);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        String currentSecurityProviderName = securityManager.getCurrentSecurityProviderName();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("currentProvider", currentSecurityProviderName);
        if (currentSecurityProviderName != null && !BUILT_IN_SECURITY_PROVIDERS.contains(currentSecurityProviderName)) {
            Properties securityProviderProperties = groupedSettingsDAO.read("securityProvider");
            List parametersList = (List)SecurityProvider.CONFIG_PARAMETERS.get(currentSecurityProviderName);
            parametersList.forEach(p -> {
                if (p.getType().equals((Object)SecurityConfigParameter.Type.BOOLEAN)) {
                    securityProviderProperties.computeIfPresent(p.getName(), (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> Boolean.valueOf(v.toString())));
                }
                if (p.getType().equals((Object)SecurityConfigParameter.Type.SECRET) || p.isSensitive()) {
                    securityProviderProperties.computeIfPresent(p.getName(), (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> "****"));
                }
            });
            response.put("configuration", securityProviderProperties);
        }
        try {
            this.printf(OBJECT_WRITER.writeValueAsString(response) + "%n", new Object[0]);
        }
        catch (JsonProcessingException e) {
            throw new CliException("Exception occurred while processing security provider properties", (Throwable)e);
        }
    }
}

