/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.field.FieldSyntaxVersion;
import org.apache.kafka.connect.transforms.field.SingleFieldPath;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public abstract class ExtractField<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    public static final String OVERVIEW_DOC = "Extract the specified field from a Struct when schema present, or a Map in the case of schemaless data. Any null values are passed through unmodified.<p/>Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    private static final String FIELD_CONFIG = "field";
    private static final String REPLACE_NULL_WITH_DEFAULT_CONFIG = "replace.null.with.default";
    public static final ConfigDef CONFIG_DEF = FieldSyntaxVersion.appendConfigTo(new ConfigDef().define("field", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.MEDIUM, "Field name to extract.").define("replace.null.with.default", ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, "Whether to replace fields that have a default value and that are null to the default value. When set to true, the default value is used, otherwise null is used."));
    private static final String PURPOSE = "field extraction";
    private SingleFieldPath fieldPath;
    private String originalPath;
    private boolean replaceNullWithDefault;

    @Override
    public String version() {
        return AppInfoParser.getVersion();
    }

    @Override
    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.originalPath = config.getString(FIELD_CONFIG);
        this.fieldPath = new SingleFieldPath(this.originalPath, FieldSyntaxVersion.fromConfig(config));
        this.replaceNullWithDefault = config.getBoolean(REPLACE_NULL_WITH_DEFAULT_CONFIG);
    }

    @Override
    public R apply(R record) {
        Schema schema = this.operatingSchema(record);
        if (schema == null) {
            Map<String, Object> value = Requirements.requireMapOrNull(this.operatingValue(record), PURPOSE);
            return this.newRecord(record, null, value == null ? null : this.fieldPath.valueFrom(value));
        }
        Struct value = Requirements.requireStructOrNull(this.operatingValue(record), PURPOSE);
        Field field = this.fieldPath.fieldFrom(schema);
        if (field == null) {
            throw new IllegalArgumentException("Unknown field: " + this.originalPath);
        }
        return this.newRecord(record, field.schema(), value == null ? null : this.fieldPath.valueFrom(value, this.replaceNullWithDefault));
    }

    @Override
    public void close() {
    }

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3);

    public static class Value<R extends ConnectRecord<R>>
    extends ExtractField<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).value();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), updatedSchema, updatedValue, ((ConnectRecord)record).timestamp());
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends ExtractField<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).key();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), updatedSchema, updatedValue, ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp());
        }
    }
}

