/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.IntNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.NullNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class EndQuorumEpochRequestDataJsonConverter {
    public static EndQuorumEpochRequestData read(JsonNode _node, short _version) {
        EndQuorumEpochRequestData _object = new EndQuorumEpochRequestData();
        JsonNode _clusterIdNode = _node.get("clusterId");
        if (_clusterIdNode == null) {
            throw new RuntimeException("EndQuorumEpochRequestData: unable to locate field 'clusterId', which is mandatory in version " + _version);
        }
        if (_clusterIdNode.isNull()) {
            _object.clusterId = null;
        } else {
            if (!_clusterIdNode.isTextual()) {
                throw new RuntimeException("EndQuorumEpochRequestData expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.clusterId = _clusterIdNode.asText();
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("EndQuorumEpochRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("EndQuorumEpochRequestData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<EndQuorumEpochRequestData.TopicData> _collection = new ArrayList<EndQuorumEpochRequestData.TopicData>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(TopicDataJsonConverter.read(_element, _version));
        }
        JsonNode _leaderEndpointsNode = _node.get("leaderEndpoints");
        if (_leaderEndpointsNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("EndQuorumEpochRequestData: unable to locate field 'leaderEndpoints', which is mandatory in version " + _version);
            }
            _object.leaderEndpoints = new EndQuorumEpochRequestData.LeaderEndpointCollection(0);
        } else {
            EndQuorumEpochRequestData.LeaderEndpointCollection _collection2;
            if (!_leaderEndpointsNode.isArray()) {
                throw new RuntimeException("EndQuorumEpochRequestData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.leaderEndpoints = _collection2 = new EndQuorumEpochRequestData.LeaderEndpointCollection(_leaderEndpointsNode.size());
            for (JsonNode _element : _leaderEndpointsNode) {
                _collection2.add(LeaderEndpointJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(EndQuorumEpochRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_object.clusterId == null) {
            _node.set("clusterId", NullNode.instance);
        } else {
            _node.set("clusterId", new TextNode(_object.clusterId));
        }
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (EndQuorumEpochRequestData.TopicData _element : _object.topics) {
            _topicsArray.add(TopicDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", _topicsArray);
        if (_version >= 1) {
            ArrayNode _leaderEndpointsArray = new ArrayNode(JsonNodeFactory.instance);
            for (EndQuorumEpochRequestData.LeaderEndpoint _element : _object.leaderEndpoints) {
                _leaderEndpointsArray.add(LeaderEndpointJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("leaderEndpoints", _leaderEndpointsArray);
        }
        return _node;
    }

    public static JsonNode write(EndQuorumEpochRequestData _object, short _version) {
        return EndQuorumEpochRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class TopicDataJsonConverter {
        public static EndQuorumEpochRequestData.TopicData read(JsonNode _node, short _version) {
            EndQuorumEpochRequestData.TopicData _object = new EndQuorumEpochRequestData.TopicData();
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'topicName', which is mandatory in version " + _version);
            }
            if (!_topicNameNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.topicName = _topicNameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            ArrayList<EndQuorumEpochRequestData.PartitionData> _collection = new ArrayList<EndQuorumEpochRequestData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(EndQuorumEpochRequestData.TopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicName", new TextNode(_object.topicName));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (EndQuorumEpochRequestData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }

        public static JsonNode write(EndQuorumEpochRequestData.TopicData _object, short _version) {
            return TopicDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class ReplicaInfoJsonConverter {
        public static EndQuorumEpochRequestData.ReplicaInfo read(JsonNode _node, short _version) {
            EndQuorumEpochRequestData.ReplicaInfo _object = new EndQuorumEpochRequestData.ReplicaInfo();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReplicaInfo");
            }
            JsonNode _candidateIdNode = _node.get("candidateId");
            if (_candidateIdNode == null) {
                throw new RuntimeException("ReplicaInfo: unable to locate field 'candidateId', which is mandatory in version " + _version);
            }
            _object.candidateId = MessageUtil.jsonNodeToInt(_candidateIdNode, "ReplicaInfo");
            JsonNode _candidateDirectoryIdNode = _node.get("candidateDirectoryId");
            if (_candidateDirectoryIdNode == null) {
                throw new RuntimeException("ReplicaInfo: unable to locate field 'candidateDirectoryId', which is mandatory in version " + _version);
            }
            if (!_candidateDirectoryIdNode.isTextual()) {
                throw new RuntimeException("ReplicaInfo expected a JSON string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.candidateDirectoryId = Uuid.fromString(_candidateDirectoryIdNode.asText());
            return _object;
        }

        public static JsonNode write(EndQuorumEpochRequestData.ReplicaInfo _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ReplicaInfo");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("candidateId", new IntNode(_object.candidateId));
            _node.set("candidateDirectoryId", new TextNode(_object.candidateDirectoryId.toString()));
            return _node;
        }

        public static JsonNode write(EndQuorumEpochRequestData.ReplicaInfo _object, short _version) {
            return ReplicaInfoJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static EndQuorumEpochRequestData.PartitionData read(JsonNode _node, short _version) {
            EndQuorumEpochRequestData.PartitionData _object = new EndQuorumEpochRequestData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _leaderIdNode = _node.get("leaderId");
            if (_leaderIdNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'leaderId', which is mandatory in version " + _version);
            }
            _object.leaderId = MessageUtil.jsonNodeToInt(_leaderIdNode, "PartitionData");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "PartitionData");
            JsonNode _preferredSuccessorsNode = _node.get("preferredSuccessors");
            if (_preferredSuccessorsNode == null) {
                if (_version <= 0) {
                    throw new RuntimeException("PartitionData: unable to locate field 'preferredSuccessors', which is mandatory in version " + _version);
                }
                _object.preferredSuccessors = new ArrayList<Integer>(0);
            } else {
                if (!_preferredSuccessorsNode.isArray()) {
                    throw new RuntimeException("PartitionData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
                }
                ArrayList<Integer> _collection = new ArrayList<Integer>(_preferredSuccessorsNode.size());
                _object.preferredSuccessors = _collection;
                for (JsonNode _element : _preferredSuccessorsNode) {
                    _collection.add(MessageUtil.jsonNodeToInt(_element, "PartitionData element"));
                }
            }
            JsonNode _preferredCandidatesNode = _node.get("preferredCandidates");
            if (_preferredCandidatesNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("PartitionData: unable to locate field 'preferredCandidates', which is mandatory in version " + _version);
                }
                _object.preferredCandidates = new ArrayList<EndQuorumEpochRequestData.ReplicaInfo>(0);
            } else {
                if (!_preferredCandidatesNode.isArray()) {
                    throw new RuntimeException("PartitionData expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
                }
                ArrayList<EndQuorumEpochRequestData.ReplicaInfo> _collection = new ArrayList<EndQuorumEpochRequestData.ReplicaInfo>(_preferredCandidatesNode.size());
                _object.preferredCandidates = _collection;
                for (JsonNode _element : _preferredCandidatesNode) {
                    _collection.add(ReplicaInfoJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }

        public static JsonNode write(EndQuorumEpochRequestData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", new IntNode(_object.partitionIndex));
            _node.set("leaderId", new IntNode(_object.leaderId));
            _node.set("leaderEpoch", new IntNode(_object.leaderEpoch));
            if (_version <= 0) {
                ArrayNode _preferredSuccessorsArray = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.preferredSuccessors) {
                    _preferredSuccessorsArray.add(new IntNode(n));
                }
                _node.set("preferredSuccessors", _preferredSuccessorsArray);
            }
            if (_version >= 1) {
                ArrayNode _preferredCandidatesArray = new ArrayNode(JsonNodeFactory.instance);
                for (EndQuorumEpochRequestData.ReplicaInfo replicaInfo : _object.preferredCandidates) {
                    _preferredCandidatesArray.add(ReplicaInfoJsonConverter.write(replicaInfo, _version, _serializeRecords));
                }
                _node.set("preferredCandidates", _preferredCandidatesArray);
            }
            return _node;
        }

        public static JsonNode write(EndQuorumEpochRequestData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class LeaderEndpointJsonConverter {
        public static EndQuorumEpochRequestData.LeaderEndpoint read(JsonNode _node, short _version) {
            EndQuorumEpochRequestData.LeaderEndpoint _object = new EndQuorumEpochRequestData.LeaderEndpoint();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderEndpoint");
            }
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("LeaderEndpoint: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("LeaderEndpoint expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("LeaderEndpoint: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("LeaderEndpoint expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.host = _hostNode.asText();
            JsonNode _portNode = _node.get("port");
            if (_portNode == null) {
                throw new RuntimeException("LeaderEndpoint: unable to locate field 'port', which is mandatory in version " + _version);
            }
            _object.port = MessageUtil.jsonNodeToUnsignedShort(_portNode, "LeaderEndpoint");
            return _object;
        }

        public static JsonNode write(EndQuorumEpochRequestData.LeaderEndpoint _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderEndpoint");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", new TextNode(_object.name));
            _node.set("host", new TextNode(_object.host));
            _node.set("port", new IntNode(_object.port));
            return _node;
        }

        public static JsonNode write(EndQuorumEpochRequestData.LeaderEndpoint _object, short _version) {
            return LeaderEndpointJsonConverter.write(_object, _version, true);
        }
    }
}

