/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableIdParser;
import io.debezium.relational.TableIdPredicates;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.util.List;

@Immutable
public final class TableId
implements DataCollectionId,
Comparable<TableId> {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final String id;

    public static TableId parse(String str) {
        return TableId.parse(str, true);
    }

    public static TableId parse(String str, TableIdPredicates predicates) {
        return TableId.parse(str, true, predicates);
    }

    public static TableId parse(String str, boolean useCatalogBeforeSchema) {
        String[] parts = TableId.parseParts(str);
        return TableId.parse(parts, parts.length, useCatalogBeforeSchema);
    }

    public static TableId parse(String str, boolean useCatalogBeforeSchema, TableIdPredicates predicates) {
        String[] parts = TableId.parseParts(str, predicates);
        return TableId.parse(parts, parts.length, useCatalogBeforeSchema);
    }

    public static String[] parseParts(String str) {
        return TableIdParser.parse(str).toArray(new String[0]);
    }

    public static String[] parseParts(String str, TableIdPredicates predicates) {
        return TableIdParser.parse(str, predicates).toArray(new String[0]);
    }

    protected static TableId parse(String[] parts, int numParts, boolean useCatalogBeforeSchema) {
        if (numParts == 0) {
            return null;
        }
        if (numParts == 1) {
            return new TableId(null, null, parts[0]);
        }
        if (numParts == 2) {
            if (useCatalogBeforeSchema) {
                return new TableId(parts[0], null, parts[1]);
            }
            return new TableId(null, parts[0], parts[1]);
        }
        return new TableId(parts[0], parts[1], parts[2]);
    }

    public TableId(String catalogName, String schemaName, String tableName, Selectors.TableIdToStringMapper tableIdMapper) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        assert (this.tableName != null);
        this.id = tableIdMapper == null ? TableId.tableId(this.catalogName, this.schemaName, this.tableName) : tableIdMapper.toString(this);
    }

    public TableId(String catalogName, String schemaName, String tableName) {
        this(catalogName, schemaName, tableName, null);
    }

    public String catalog() {
        return this.catalogName;
    }

    public String schema() {
        return this.schemaName;
    }

    public String table() {
        return this.tableName;
    }

    @Override
    public String identifier() {
        return this.id;
    }

    @Override
    public List<String> parts() {
        return Collect.arrayListOf(this.catalogName, this.schemaName, this.tableName);
    }

    @Override
    public List<String> databaseParts() {
        return Collect.arrayListOf(this.catalogName, this.tableName);
    }

    @Override
    public List<String> schemaParts() {
        return Collect.arrayListOf(this.schemaName, this.tableName);
    }

    @Override
    public int compareTo(TableId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareTo(that.id);
    }

    public int compareToIgnoreCase(TableId that) {
        if (this == that) {
            return 0;
        }
        return this.id.compareToIgnoreCase(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableId) {
            return this.compareTo((TableId)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.identifier();
    }

    public String toDoubleQuotedString() {
        return this.toQuotedString('\"');
    }

    public TableId toDoubleQuoted() {
        return this.toQuoted('\"');
    }

    public TableId toQuoted(char quotingChar) {
        String catalogName = null;
        if (this.catalogName != null && !this.catalogName.isEmpty()) {
            catalogName = TableId.quote(this.catalogName, quotingChar);
        }
        String schemaName = null;
        if (this.schemaName != null && !this.schemaName.isEmpty()) {
            schemaName = TableId.quote(this.schemaName, quotingChar);
        }
        return new TableId(catalogName, schemaName, TableId.quote(this.tableName, quotingChar));
    }

    public String toQuotedString(char quotingChar) {
        StringBuilder quoted = new StringBuilder();
        if (this.catalogName != null && !this.catalogName.isEmpty()) {
            quoted.append(TableId.quote(this.catalogName, quotingChar)).append(".");
        }
        if (this.schemaName != null && !this.schemaName.isEmpty()) {
            quoted.append(TableId.quote(this.schemaName, quotingChar)).append(".");
        }
        quoted.append(TableId.quote(this.tableName, quotingChar));
        return quoted.toString();
    }

    private static String tableId(String catalog, String schema, String table) {
        if (catalog == null || catalog.isEmpty()) {
            if (schema == null || schema.isEmpty()) {
                return table;
            }
            return schema + "." + table;
        }
        if (schema == null || schema.isEmpty()) {
            return catalog + "." + table;
        }
        return catalog + "." + schema + "." + table;
    }

    private static String quote(String identifierPart, char quotingChar) {
        if (identifierPart == null) {
            return null;
        }
        if (((String)identifierPart).isEmpty()) {
            return TableId.repeat(quotingChar);
        }
        if (((String)identifierPart).charAt(0) != quotingChar && ((String)identifierPart).charAt(((String)identifierPart).length() - 1) != quotingChar) {
            identifierPart = ((String)identifierPart).replace("" + quotingChar, TableId.repeat(quotingChar));
            identifierPart = quotingChar + (String)identifierPart + quotingChar;
        }
        return identifierPart;
    }

    private static String repeat(char quotingChar) {
        return "" + quotingChar + quotingChar;
    }

    public TableId toLowercase() {
        return new TableId(this.catalogName, this.schemaName, this.tableName.toLowerCase());
    }
}

