/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.embedded.ConverterBuilder;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.ChangeEventFormat;
import io.debezium.engine.format.KeyValueChangeEventFormat;
import io.debezium.engine.format.KeyValueHeaderChangeEventFormat;
import io.debezium.engine.spi.OffsetCommitPolicy;
import java.io.IOException;
import java.time.Clock;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.HeaderConverter;

public class ConvertingEngineBuilder<R>
implements DebeziumEngine.Builder<R> {
    private final DebeziumEngine.Builder<SourceRecord> delegate = new EmbeddedEngine.EngineBuilder();
    private final ConverterBuilder converterBuilder = new ConverterBuilder();
    private Function<SourceRecord, R> toFormat;
    private Function<R, SourceRecord> fromFormat;

    ConvertingEngineBuilder(ChangeEventFormat<?> format) {
        this(KeyValueHeaderChangeEventFormat.of(null, format.getValueFormat(), null));
    }

    ConvertingEngineBuilder(KeyValueChangeEventFormat<?, ?> format) {
        this(format instanceof KeyValueHeaderChangeEventFormat ? (KeyValueHeaderChangeEventFormat)format : KeyValueHeaderChangeEventFormat.of(format.getKeyFormat(), format.getValueFormat(), null));
    }

    ConvertingEngineBuilder(KeyValueHeaderChangeEventFormat<?, ?, ?> format) {
        this.converterBuilder.using(format);
    }

    @Override
    public DebeziumEngine.Builder<R> notifying(Consumer<R> consumer) {
        this.delegate.notifying((R record) -> consumer.accept(this.toFormat.apply((SourceRecord)record)));
        return this;
    }

    @Override
    public DebeziumEngine.Builder<R> notifying(DebeziumEngine.ChangeConsumer<R> handler) {
        this.delegate.notifying(new ConvertingChangeConsumer(handler));
        return this;
    }

    @Override
    public DebeziumEngine.Builder<R> using(Properties config) {
        this.converterBuilder.using(config);
        this.delegate.using(config);
        return this;
    }

    @Override
    public DebeziumEngine.Builder<R> using(ClassLoader classLoader) {
        this.delegate.using(classLoader);
        return this;
    }

    @Override
    public DebeziumEngine.Builder<R> using(Clock clock) {
        this.delegate.using(clock);
        return this;
    }

    @Override
    public DebeziumEngine.Builder<R> using(DebeziumEngine.CompletionCallback completionCallback) {
        this.delegate.using(completionCallback);
        return this;
    }

    @Override
    public DebeziumEngine.Builder<R> using(DebeziumEngine.ConnectorCallback connectorCallback) {
        this.delegate.using(connectorCallback);
        return this;
    }

    @Override
    public DebeziumEngine.Builder<R> using(OffsetCommitPolicy policy) {
        this.delegate.using(policy);
        return this;
    }

    @Override
    public DebeziumEngine<R> build() {
        final DebeziumEngine<SourceRecord> engine = this.delegate.build();
        final HeaderConverter headerConverter = this.converterBuilder.headerConverter();
        this.toFormat = this.converterBuilder.toFormat(headerConverter);
        this.fromFormat = this.converterBuilder.fromFormat();
        return new DebeziumEngine<R>(){

            @Override
            public void run() {
                engine.run();
            }

            @Override
            public void close() throws IOException {
                if (headerConverter != null) {
                    headerConverter.close();
                }
                engine.close();
            }
        };
    }

    private class ConvertingChangeConsumer
    implements DebeziumEngine.ChangeConsumer<SourceRecord> {
        private final DebeziumEngine.ChangeConsumer<R> handler;

        private ConvertingChangeConsumer(DebeziumEngine.ChangeConsumer<R> handler) {
            this.handler = handler;
        }

        @Override
        public void handleBatch(List<SourceRecord> records, final DebeziumEngine.RecordCommitter<SourceRecord> committer) throws InterruptedException {
            this.handler.handleBatch(records.stream().map(x -> ConvertingEngineBuilder.this.toFormat.apply((SourceRecord)x)).collect(Collectors.toList()), new DebeziumEngine.RecordCommitter<R>(){

                @Override
                public void markProcessed(R record) throws InterruptedException {
                    committer.markProcessed(ConvertingEngineBuilder.this.fromFormat.apply(record));
                }

                @Override
                public void markBatchFinished() throws InterruptedException {
                    committer.markBatchFinished();
                }

                @Override
                public void markProcessed(R record, DebeziumEngine.Offsets sourceOffsets) throws InterruptedException {
                    committer.markProcessed(ConvertingEngineBuilder.this.fromFormat.apply(record), sourceOffsets);
                }

                @Override
                public DebeziumEngine.Offsets buildOffsets() {
                    return committer.buildOffsets();
                }
            });
        }

        @Override
        public boolean supportsTombstoneEvents() {
            return this.handler.supportsTombstoneEvents();
        }
    }
}

